/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoders;
import org.apache.beam.sdk.values.RowType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.BiMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class CalciteUtils {
    private static final BiMap<SqlTypeCoder, SqlTypeName> BEAM_TO_CALCITE_TYPE_MAPPING = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)SqlTypeCoders.TINYINT, (Object)SqlTypeName.TINYINT)).put((Object)SqlTypeCoders.SMALLINT, (Object)SqlTypeName.SMALLINT)).put((Object)SqlTypeCoders.INTEGER, (Object)SqlTypeName.INTEGER)).put((Object)SqlTypeCoders.BIGINT, (Object)SqlTypeName.BIGINT)).put((Object)SqlTypeCoders.FLOAT, (Object)SqlTypeName.FLOAT)).put((Object)SqlTypeCoders.DOUBLE, (Object)SqlTypeName.DOUBLE)).put((Object)SqlTypeCoders.DECIMAL, (Object)SqlTypeName.DECIMAL)).put((Object)SqlTypeCoders.CHAR, (Object)SqlTypeName.CHAR)).put((Object)SqlTypeCoders.VARCHAR, (Object)SqlTypeName.VARCHAR)).put((Object)SqlTypeCoders.DATE, (Object)SqlTypeName.DATE)).put((Object)SqlTypeCoders.TIME, (Object)SqlTypeName.TIME)).put((Object)SqlTypeCoders.TIMESTAMP, (Object)SqlTypeName.TIMESTAMP)).put((Object)SqlTypeCoders.BOOLEAN, (Object)SqlTypeName.BOOLEAN)).build();
    private static final BiMap<SqlTypeName, SqlTypeCoder> CALCITE_TO_BEAM_TYPE_MAPPING = BEAM_TO_CALCITE_TYPE_MAPPING.inverse();

    public static SqlTypeName toCalciteType(SqlTypeCoder coder) {
        return (SqlTypeName)((Object)BEAM_TO_CALCITE_TYPE_MAPPING.get((Object)coder));
    }

    public static SqlTypeCoder toCoder(SqlTypeName typeName) {
        return (SqlTypeCoder)((Object)CALCITE_TO_BEAM_TYPE_MAPPING.get((Object)typeName));
    }

    public static SqlTypeName getFieldCalciteType(RowType schema, int index) {
        return CalciteUtils.toCalciteType((SqlTypeCoder)schema.getFieldCoder(index));
    }

    public static RowType toBeamRowType(RelDataType tableInfo) {
        return (RowType)tableInfo.getFieldList().stream().map(CalciteUtils::toBeamRowField).collect(RowType.toRowType());
    }

    private static RowType.Field toBeamRowField(RelDataTypeField calciteField) {
        return RowType.newField((String)calciteField.getName(), (Coder)CalciteUtils.toCoder(calciteField.getType().getSqlTypeName()));
    }

    public static RelProtoDataType toCalciteRowType(RowType rowType) {
        return fieldInfo -> {
            RelDataTypeFactory.FieldInfoBuilder builder = fieldInfo.builder();
            for (int idx = 0; idx < rowType.getFieldNames().size(); ++idx) {
                builder.add(rowType.getFieldName(idx), CalciteUtils.toCalciteType((SqlTypeCoder)rowType.getFieldCoder(idx)));
            }
            return builder.build();
        };
    }
}

