/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionExecutor;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;

public class BeamSqlProjectFn
extends DoFn<Row, Row> {
    private String stepName;
    private BeamSqlExpressionExecutor executor;
    private RowType outputRowType;

    public BeamSqlProjectFn(String stepName, BeamSqlExpressionExecutor executor, RowType outputRowType) {
        this.stepName = stepName;
        this.executor = executor;
        this.outputRowType = outputRowType;
    }

    @DoFn.Setup
    public void setup() {
        this.executor.prepare();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
        Row inputRow = (Row)c.element();
        List<Object> rawResultValues = this.executor.execute(inputRow, window);
        List castResultValues = IntStream.range(0, this.outputRowType.getFieldCount()).mapToObj(i -> this.castField(rawResultValues, i)).collect(Collectors.toList());
        c.output((Object)Row.withRowType((RowType)this.outputRowType).addValues(castResultValues).build());
    }

    private Object castField(List<Object> resultValues, int i) {
        return BeamTableUtils.autoCastField(this.outputRowType.getFieldCoder(i), resultValues.get(i));
    }

    @DoFn.Teardown
    public void close() {
        this.executor.close();
    }
}

