/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.stream.IntStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoder;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.NlsString;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public final class BeamTableUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Row csvLine2BeamRow(CSVFormat csvFormat, String line, RowType rowType) {
        try (StringReader reader = new StringReader(line);){
            CSVParser parser = csvFormat.parse((Reader)reader);
            CSVRecord rawRecord = (CSVRecord)parser.getRecords().get(0);
            if (rawRecord.size() != rowType.getFieldCount()) {
                throw new IllegalArgumentException(String.format("Expect %d fields, but actually %d", rowType.getFieldCount(), rawRecord.size()));
            }
            Row row = (Row)IntStream.range(0, rowType.getFieldCount()).mapToObj(idx -> BeamTableUtils.autoCastField(rowType.getFieldCoder(idx), rawRecord.get(idx))).collect(Row.toRow((RowType)rowType));
            return row;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("decodeRecord failed!", e);
        }
    }

    public static String beamRow2CsvLine(Row row, CSVFormat csvFormat) {
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = csvFormat.print((Appendable)writer);){
            for (int i = 0; i < row.getFieldCount(); ++i) {
                printer.print((Object)row.getValue(i).toString());
            }
            printer.println();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("encodeRecord failed!", e);
        }
        return writer.toString();
    }

    public static Object autoCastField(Coder coder, Object rawObj) {
        Preconditions.checkArgument(coder instanceof SqlTypeCoder);
        if (rawObj == null) {
            return null;
        }
        SqlTypeName columnType = CalciteUtils.toCalciteType((SqlTypeCoder)coder);
        if (rawObj instanceof String && SqlTypeName.NUMERIC_TYPES.contains((Object)columnType) || rawObj instanceof BigDecimal && columnType != SqlTypeName.DECIMAL) {
            String raw = rawObj.toString();
            switch (columnType) {
                case TINYINT: {
                    return Byte.valueOf(raw);
                }
                case SMALLINT: {
                    return Short.valueOf(raw);
                }
                case INTEGER: {
                    return Integer.valueOf(raw);
                }
                case BIGINT: {
                    return Long.valueOf(raw);
                }
                case FLOAT: {
                    return Float.valueOf(raw);
                }
                case DOUBLE: {
                    return Double.valueOf(raw);
                }
            }
            throw new UnsupportedOperationException(String.format("Column type %s is not supported yet!", new Object[]{columnType}));
        }
        if (SqlTypeName.CHAR_TYPES.contains((Object)columnType)) {
            if (rawObj instanceof NlsString) {
                return ((NlsString)rawObj).getValue();
            }
            return rawObj;
        }
        return rawObj;
    }
}

