/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Values;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;

public class BeamValuesRel
extends Values
implements BeamRelNode {
    public BeamValuesRel(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, rowType, tuples, traits);
    }

    @Override
    public PTransform<PCollectionTuple, PCollection<Row>> toPTransform() {
        return new Transform();
    }

    private Row tupleToRow(RowType rowType, ImmutableList<RexLiteral> tuple) {
        return (Row)IntStream.range(0, tuple.size()).mapToObj(i -> BeamTableUtils.autoCastField(rowType.getFieldCoder(i), ((RexLiteral)tuple.get(i)).getValue())).collect(Row.toRow((RowType)rowType));
    }

    private class Transform
    extends PTransform<PCollectionTuple, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionTuple inputPCollections) {
            String stageName = BeamSqlRelUtils.getStageName(BeamValuesRel.this);
            if (BeamValuesRel.this.tuples.isEmpty()) {
                throw new IllegalStateException("Values with empty tuples!");
            }
            RowType rowType = CalciteUtils.toBeamRowType(BeamValuesRel.this.getRowType());
            List rows = BeamValuesRel.this.tuples.stream().map(tuple -> BeamValuesRel.this.tupleToRow(rowType, tuple)).collect(Collectors.toList());
            return ((PCollection)inputPCollections.getPipeline().apply(stageName, (PTransform)Create.of(rows))).setCoder((Coder)rowType.getRowCoder());
        }
    }
}

