/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.ArrayList;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.parser.ColumnConstraint;
import org.apache.beam.sdk.extensions.sql.impl.parser.ColumnDefinition;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlCreateTable;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Column;
import org.apache.beam.sdk.extensions.sql.meta.Table;

public class ParserUtils {
    public static Table convertCreateTableStmtToTable(SqlCreateTable stmt) {
        ArrayList<Column> columns = new ArrayList<Column>(stmt.fieldList().size());
        for (ColumnDefinition columnDef : stmt.fieldList()) {
            Column column = Column.builder().name(columnDef.name().toLowerCase()).coder((Coder)CalciteUtils.toCoder(columnDef.type().deriveType(BeamQueryPlanner.TYPE_FACTORY).getSqlTypeName())).comment(columnDef.comment()).primaryKey(columnDef.constraint() instanceof ColumnConstraint.PrimaryKey).build();
            columns.add(column);
        }
        Table table = Table.builder().type(stmt.type().toLowerCase()).name(stmt.tableName().toLowerCase()).columns(columns).comment(stmt.comment()).location(stmt.location()).properties(stmt.properties()).build();
        return table;
    }
}

