/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlTrimExpression
extends BeamSqlExpression {
    public BeamSqlTrimExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.VARCHAR);
    }

    @Override
    public boolean accept() {
        if (this.operands.size() != 1 && this.operands.size() != 3) {
            return false;
        }
        if (this.operands.size() == 1 && !SqlTypeName.CHAR_TYPES.contains((Object)this.opType(0))) {
            return false;
        }
        return this.operands.size() != 3 || SqlTypeName.SYMBOL == this.opType(0) && SqlTypeName.CHAR_TYPES.contains((Object)this.opType(1)) && SqlTypeName.CHAR_TYPES.contains((Object)this.opType(2));
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window) {
        if (this.operands.size() == 1) {
            return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, this.opValueEvaluated(0, inputRow, window).toString().trim());
        }
        SqlTrimFunction.Flag type = (SqlTrimFunction.Flag)((Object)this.opValueEvaluated(0, inputRow, window));
        String targetStr = (String)this.opValueEvaluated(1, inputRow, window);
        String containingStr = (String)this.opValueEvaluated(2, inputRow, window);
        switch (type) {
            case LEADING: {
                return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, BeamSqlTrimExpression.leadingTrim(containingStr, targetStr));
            }
            case TRAILING: {
                return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, BeamSqlTrimExpression.trailingTrim(containingStr, targetStr));
            }
        }
        return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, BeamSqlTrimExpression.trailingTrim(BeamSqlTrimExpression.leadingTrim(containingStr, targetStr), targetStr));
    }

    static String leadingTrim(String containingStr, String targetStr) {
        int idx = 0;
        while (containingStr.startsWith(targetStr, idx)) {
            idx += targetStr.length();
        }
        return containingStr.substring(idx);
    }

    static String trailingTrim(String containingStr, String targetStr) {
        int idx = containingStr.length() - targetStr.length();
        while (containingStr.startsWith(targetStr, idx)) {
            idx -= targetStr.length();
        }
        return containingStr.substring(0, idx += targetStr.length());
    }
}

