/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlConcatExpression
extends BeamSqlExpression {
    protected BeamSqlConcatExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    public BeamSqlConcatExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.VARCHAR);
    }

    @Override
    public boolean accept() {
        if (this.operands.size() != 2) {
            return false;
        }
        for (BeamSqlExpression exp : this.getOperands()) {
            if (SqlTypeName.CHAR_TYPES.contains((Object)exp.getOutputType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window) {
        String left = (String)this.opValueEvaluated(0, inputRow, window);
        String right = (String)this.opValueEvaluated(1, inputRow, window);
        return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, new StringBuilder(left.length() + right.length()).append(left).append(right).toString());
    }
}

