/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamPCollectionTable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.DataContext;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.ScannableTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Schema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Statistic;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Statistics;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Frameworks;

public class BeamSqlEnv
implements Serializable {
    transient SchemaPlus schema;
    transient BeamQueryPlanner planner;
    transient Map<String, BeamSqlTable> tables = new HashMap<String, BeamSqlTable>(16);

    public BeamSqlEnv() {
        this.schema = Frameworks.createRootSchema(true);
        this.planner = new BeamQueryPlanner(this, this.schema);
    }

    public void registerUdf(String functionName, Class<?> clazz, String method) {
        this.schema.add(functionName, ScalarFunctionImpl.create(clazz, method));
    }

    public void registerUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
        this.registerUdf(functionName, clazz, "eval");
    }

    public void registerUdf(String functionName, SerializableFunction sfn) {
        this.registerUdf(functionName, sfn.getClass(), "apply");
    }

    public void registerUdaf(String functionName, Combine.CombineFn combineFn) {
        this.schema.add(functionName, new UdafImpl(combineFn));
    }

    public void registerPCollectionTuple(PCollectionTuple pCollectionTuple) {
        pCollectionTuple.getAll().forEach((tag, pCollection) -> this.registerPCollection(tag.getId(), (PCollection<Row>)pCollection));
    }

    public void registerPCollection(String name, PCollection<Row> pCollection) {
        this.registerTable(name, pCollection, ((RowCoder)pCollection.getCoder()).getRowType());
    }

    public void registerTable(String tableName, PCollection<Row> pCollection, RowType rowType) {
        this.registerTable(tableName, new BeamPCollectionTable(pCollection, rowType));
    }

    public void registerTable(String tableName, BeamSqlTable table) {
        this.tables.put(tableName, table);
        this.schema.add(tableName, new BeamCalciteTable(table.getRowType()));
        this.planner.getSourceTables().put(tableName, table);
    }

    public void deregisterTable(String targetTableName) {
        this.schema = Frameworks.createRootSchema(true);
        for (Map.Entry<String, BeamSqlTable> entry : this.tables.entrySet()) {
            String tableName = entry.getKey();
            BeamSqlTable table = entry.getValue();
            if (tableName.equals(targetTableName)) continue;
            this.schema.add(tableName, new BeamCalciteTable(table.getRowType()));
        }
        this.planner = new BeamQueryPlanner(this, this.schema);
    }

    public BeamSqlTable findTable(String tableName) {
        return this.planner.getSourceTables().get(tableName);
    }

    public BeamQueryPlanner getPlanner() {
        return this.planner;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.tables = new HashMap<String, BeamSqlTable>(16);
        this.schema = Frameworks.createRootSchema(true);
        this.planner = new BeamQueryPlanner(this, this.schema);
    }

    private static class BeamCalciteTable
    implements ScannableTable,
    Serializable {
        private RowType beamRowType;

        public BeamCalciteTable(RowType beamRowType) {
            this.beamRowType = beamRowType;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return (RelDataType)CalciteUtils.toCalciteRowType(this.beamRowType).apply(BeamQueryPlanner.TYPE_FACTORY);
        }

        @Override
        public Enumerable<Object[]> scan(DataContext root) {
            return null;
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        @Override
        public boolean isRolledUp(String column) {
            return false;
        }

        @Override
        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
            return false;
        }
    }
}

