/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.SqlTypeCoders;
import org.apache.beam.sdk.values.RowType;
import org.apache.beam.sdk.values.reflect.FieldValueGetter;
import org.apache.beam.sdk.values.reflect.RowTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMap;

@Internal
public class SqlRowTypeFactory
implements RowTypeFactory {
    static final ImmutableMap<Class, Coder> SQL_CODERS = ImmutableMap.builder().put(Byte.class, SqlTypeCoders.TINYINT).put(Short.class, SqlTypeCoders.SMALLINT).put(Integer.class, SqlTypeCoders.INTEGER).put(Long.class, SqlTypeCoders.BIGINT).put(Float.class, SqlTypeCoders.FLOAT).put(Double.class, SqlTypeCoders.DOUBLE).put(BigDecimal.class, SqlTypeCoders.DECIMAL).put(Boolean.class, SqlTypeCoders.BOOLEAN).put(String.class, SqlTypeCoders.VARCHAR).put(GregorianCalendar.class, SqlTypeCoders.TIME).put(Date.class, SqlTypeCoders.TIMESTAMP).build();

    public RowType createRowType(Iterable<FieldValueGetter> getters) {
        return RowType.fromNamesAndCoders(this.fieldNames(getters), this.sqlCoders(getters));
    }

    private List<String> fieldNames(Iterable<FieldValueGetter> getters) {
        ImmutableList.Builder names = ImmutableList.builder();
        for (FieldValueGetter fieldValueGetter : getters) {
            names.add(fieldValueGetter.name());
        }
        return names.build();
    }

    private List<Coder> sqlCoders(Iterable<FieldValueGetter> getters) {
        ImmutableList.Builder sqlCoders = ImmutableList.builder();
        for (FieldValueGetter fieldValueGetter : getters) {
            if (!SQL_CODERS.containsKey(fieldValueGetter.type())) {
                throw new UnsupportedOperationException("Field type " + fieldValueGetter.type().getSimpleName() + " is not supported yet");
            }
            sqlCoders.add(SQL_CODERS.get(fieldValueGetter.type()));
        }
        return sqlCoders.build();
    }
}

