/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.CoderException;

@Experimental
public class RowHelper {

    public static class BooleanCoder
    extends AtomicCoder<Boolean> {
        private static final BooleanCoder INSTANCE = new BooleanCoder();

        public static BooleanCoder of() {
            return INSTANCE;
        }

        private BooleanCoder() {
        }

        public void encode(Boolean value, OutputStream outStream) throws CoderException, IOException {
            new DataOutputStream(outStream).writeBoolean(value);
        }

        public Boolean decode(InputStream inStream) throws CoderException, IOException {
            return new DataInputStream(inStream).readBoolean();
        }
    }

    public static class DateCoder
    extends AtomicCoder<Date> {
        private static final BigEndianLongCoder longCoder = BigEndianLongCoder.of();
        private static final DateCoder INSTANCE = new DateCoder();

        public static DateCoder of() {
            return INSTANCE;
        }

        private DateCoder() {
        }

        public void encode(Date value, OutputStream outStream) throws CoderException, IOException {
            longCoder.encode(Long.valueOf(value.getTime()), outStream);
        }

        public Date decode(InputStream inStream) throws CoderException, IOException {
            return new Date(longCoder.decode(inStream));
        }
    }

    public static class TimeCoder
    extends AtomicCoder<GregorianCalendar> {
        private static final BigEndianLongCoder longCoder = BigEndianLongCoder.of();
        private static final TimeCoder INSTANCE = new TimeCoder();

        public static TimeCoder of() {
            return INSTANCE;
        }

        private TimeCoder() {
        }

        public void encode(GregorianCalendar value, OutputStream outStream) throws CoderException, IOException {
            longCoder.encode(Long.valueOf(value.getTime().getTime()), outStream);
        }

        public GregorianCalendar decode(InputStream inStream) throws CoderException, IOException {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date(longCoder.decode(inStream)));
            return calendar;
        }
    }

    public static class DoubleCoder
    extends AtomicCoder<Double> {
        private static final DoubleCoder INSTANCE = new DoubleCoder();
        private static final BigDecimalCoder CODER = BigDecimalCoder.of();

        public static DoubleCoder of() {
            return INSTANCE;
        }

        private DoubleCoder() {
        }

        public void encode(Double value, OutputStream outStream) throws CoderException, IOException {
            CODER.encode(new BigDecimal(value), outStream);
        }

        public Double decode(InputStream inStream) throws CoderException, IOException {
            return CODER.decode(inStream).doubleValue();
        }
    }

    public static class FloatCoder
    extends AtomicCoder<Float> {
        private static final FloatCoder INSTANCE = new FloatCoder();
        private static final BigDecimalCoder CODER = BigDecimalCoder.of();

        public static FloatCoder of() {
            return INSTANCE;
        }

        private FloatCoder() {
        }

        public void encode(Float value, OutputStream outStream) throws CoderException, IOException {
            CODER.encode(new BigDecimal(value.floatValue()), outStream);
        }

        public Float decode(InputStream inStream) throws CoderException, IOException {
            return Float.valueOf(CODER.decode(inStream).floatValue());
        }
    }

    public static class ShortCoder
    extends AtomicCoder<Short> {
        private static final ShortCoder INSTANCE = new ShortCoder();

        public static ShortCoder of() {
            return INSTANCE;
        }

        private ShortCoder() {
        }

        public void encode(Short value, OutputStream outStream) throws CoderException, IOException {
            new DataOutputStream(outStream).writeShort(value.shortValue());
        }

        public Short decode(InputStream inStream) throws CoderException, IOException {
            return new DataInputStream(inStream).readShort();
        }
    }
}

