/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.QueryTransform;

final class AutoValue_QueryTransform
extends QueryTransform {
    private final String queryString;
    private final List<QueryTransform.UdfDefinition> udfDefinitions;
    private final List<QueryTransform.UdafDefinition> udafDefinitions;

    private AutoValue_QueryTransform(String queryString, List<QueryTransform.UdfDefinition> udfDefinitions, List<QueryTransform.UdafDefinition> udafDefinitions) {
        this.queryString = queryString;
        this.udfDefinitions = udfDefinitions;
        this.udafDefinitions = udafDefinitions;
    }

    @Override
    String queryString() {
        return this.queryString;
    }

    @Override
    List<QueryTransform.UdfDefinition> udfDefinitions() {
        return this.udfDefinitions;
    }

    @Override
    List<QueryTransform.UdafDefinition> udafDefinitions() {
        return this.udafDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryTransform) {
            QueryTransform that = (QueryTransform)((Object)o);
            return this.queryString.equals(that.queryString()) && this.udfDefinitions.equals(that.udfDefinitions()) && this.udafDefinitions.equals(that.udafDefinitions());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.queryString.hashCode();
        h *= 1000003;
        h ^= this.udfDefinitions.hashCode();
        h *= 1000003;
        return h ^= this.udafDefinitions.hashCode();
    }

    @Override
    QueryTransform.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryTransform.Builder {
        private String queryString;
        private List<QueryTransform.UdfDefinition> udfDefinitions;
        private List<QueryTransform.UdafDefinition> udafDefinitions;

        Builder() {
        }

        private Builder(QueryTransform source) {
            this.queryString = source.queryString();
            this.udfDefinitions = source.udfDefinitions();
            this.udafDefinitions = source.udafDefinitions();
        }

        @Override
        QueryTransform.Builder setQueryString(String queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        QueryTransform.Builder setUdfDefinitions(List<QueryTransform.UdfDefinition> udfDefinitions) {
            if (udfDefinitions == null) {
                throw new NullPointerException("Null udfDefinitions");
            }
            this.udfDefinitions = udfDefinitions;
            return this;
        }

        @Override
        QueryTransform.Builder setUdafDefinitions(List<QueryTransform.UdafDefinition> udafDefinitions) {
            if (udafDefinitions == null) {
                throw new NullPointerException("Null udafDefinitions");
            }
            this.udafDefinitions = udafDefinitions;
            return this;
        }

        @Override
        QueryTransform build() {
            String missing = "";
            if (this.queryString == null) {
                missing = missing + " queryString";
            }
            if (this.udfDefinitions == null) {
                missing = missing + " udfDefinitions";
            }
            if (this.udafDefinitions == null) {
                missing = missing + " udafDefinitions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_QueryTransform(this.queryString, this.udfDefinitions, this.udafDefinitions);
        }
    }
}

