/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.BiMap;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.Instant;
import org.joda.time.base.AbstractInstant;

public class CalciteUtils {
    private static final long UNLIMITED_ARRAY_SIZE = -1L;
    public static final Schema.FieldType TINY_INT = Schema.FieldType.BYTE;
    public static final Schema.FieldType SMALL_INT = Schema.FieldType.INT16;
    public static final Schema.FieldType INTEGER = Schema.FieldType.INT32;
    public static final Schema.FieldType BIG_INT = Schema.FieldType.INT64;
    public static final Schema.FieldType FLOAT = Schema.FieldType.FLOAT;
    public static final Schema.FieldType DOUBLE = Schema.FieldType.DOUBLE;
    public static final Schema.FieldType DECIMAL = Schema.FieldType.DECIMAL;
    public static final Schema.FieldType BOOLEAN = Schema.FieldType.BOOLEAN;
    public static final Schema.FieldType VARBINARY = Schema.FieldType.BYTES;
    public static final Schema.FieldType VARCHAR = Schema.FieldType.STRING;
    public static final Schema.FieldType CHAR = Schema.FieldType.logicalType((Schema.LogicalType)new CharType());
    public static final Schema.FieldType DATE = Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE);
    public static final Schema.FieldType NULLABLE_DATE = Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE).withNullable(true);
    public static final Schema.FieldType TIME = Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME);
    public static final Schema.FieldType NULLABLE_TIME = Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME).withNullable(true);
    public static final Schema.FieldType TIME_WITH_LOCAL_TZ = Schema.FieldType.logicalType((Schema.LogicalType)new TimeWithLocalTzType());
    public static final Schema.FieldType TIMESTAMP = Schema.FieldType.DATETIME;
    public static final Schema.FieldType NULLABLE_TIMESTAMP = Schema.FieldType.DATETIME.withNullable(true);
    public static final Schema.FieldType TIMESTAMP_WITH_LOCAL_TZ = Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME);
    public static final Schema.FieldType NULLABLE_TIMESTAMP_WITH_LOCAL_TZ = Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME).withNullable(true);
    private static final BiMap<Schema.FieldType, SqlTypeName> BEAM_TO_CALCITE_TYPE_MAPPING = ImmutableBiMap.builder().put((Object)TINY_INT, (Object)SqlTypeName.TINYINT).put((Object)SMALL_INT, (Object)SqlTypeName.SMALLINT).put((Object)INTEGER, (Object)SqlTypeName.INTEGER).put((Object)BIG_INT, (Object)SqlTypeName.BIGINT).put((Object)FLOAT, (Object)SqlTypeName.FLOAT).put((Object)DOUBLE, (Object)SqlTypeName.DOUBLE).put((Object)DECIMAL, (Object)SqlTypeName.DECIMAL).put((Object)BOOLEAN, (Object)SqlTypeName.BOOLEAN).put((Object)VARBINARY, (Object)SqlTypeName.VARBINARY).put((Object)VARCHAR, (Object)SqlTypeName.VARCHAR).put((Object)CHAR, (Object)SqlTypeName.CHAR).put((Object)DATE, (Object)SqlTypeName.DATE).put((Object)TIME, (Object)SqlTypeName.TIME).put((Object)TIME_WITH_LOCAL_TZ, (Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).put((Object)TIMESTAMP, (Object)SqlTypeName.TIMESTAMP).put((Object)TIMESTAMP_WITH_LOCAL_TZ, (Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build();
    private static final ImmutableMap<SqlTypeName, Schema.FieldType> CALCITE_TO_BEAM_TYPE_MAPPING = ImmutableMap.builder().put((Object)SqlTypeName.TINYINT, (Object)TINY_INT).put((Object)SqlTypeName.SMALLINT, (Object)SMALL_INT).put((Object)SqlTypeName.INTEGER, (Object)INTEGER).put((Object)SqlTypeName.BIGINT, (Object)BIG_INT).put((Object)SqlTypeName.FLOAT, (Object)FLOAT).put((Object)SqlTypeName.DOUBLE, (Object)DOUBLE).put((Object)SqlTypeName.DECIMAL, (Object)DECIMAL).put((Object)SqlTypeName.BOOLEAN, (Object)BOOLEAN).put((Object)SqlTypeName.VARBINARY, (Object)VARBINARY).put((Object)SqlTypeName.BINARY, (Object)VARBINARY).put((Object)SqlTypeName.VARCHAR, (Object)VARCHAR).put((Object)SqlTypeName.CHAR, (Object)CHAR).put((Object)SqlTypeName.DATE, (Object)DATE).put((Object)SqlTypeName.TIME, (Object)TIME).put((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, (Object)TIME_WITH_LOCAL_TZ).put((Object)SqlTypeName.TIMESTAMP, (Object)TIMESTAMP).put((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (Object)TIMESTAMP_WITH_LOCAL_TZ).build();
    private static final Map<Schema.FieldType, SqlTypeName> BEAM_TO_CALCITE_DEFAULT_MAPPING = ImmutableMap.of((Object)Schema.FieldType.DATETIME, (Object)SqlTypeName.TIMESTAMP, (Object)Schema.FieldType.STRING, (Object)SqlTypeName.VARCHAR);

    public static boolean isDateTimeType(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.DATETIME) {
            return true;
        }
        if (fieldType.getTypeName().isLogicalType()) {
            Schema.LogicalType logicalType = fieldType.getLogicalType();
            Preconditions.checkArgumentNotNull((Object)logicalType);
            String logicalId = logicalType.getIdentifier();
            return logicalId.equals(SqlTypes.DATE.getIdentifier()) || logicalId.equals(SqlTypes.TIME.getIdentifier()) || logicalId.equals("SqlTimeWithLocalTzType") || logicalId.equals(SqlTypes.DATETIME.getIdentifier());
        }
        return false;
    }

    public static boolean isStringType(Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.STRING) {
            return true;
        }
        if (fieldType.getTypeName().isLogicalType()) {
            Schema.LogicalType logicalType = fieldType.getLogicalType();
            Preconditions.checkArgumentNotNull((Object)logicalType);
            String logicalId = logicalType.getIdentifier();
            return logicalId.equals("SqlCharType");
        }
        return false;
    }

    public static Schema toSchema(RelDataType tableInfo) {
        return (Schema)tableInfo.getFieldList().stream().map(CalciteUtils::toField).collect(Schema.toSchema());
    }

    public static SqlTypeName toSqlTypeName(Schema.FieldType type) {
        switch (type.getTypeName()) {
            case ROW: {
                return SqlTypeName.ROW;
            }
            case ARRAY: 
            case ITERABLE: {
                return SqlTypeName.ARRAY;
            }
            case MAP: {
                return SqlTypeName.MAP;
            }
        }
        SqlTypeName typeName = (SqlTypeName)BEAM_TO_CALCITE_TYPE_MAPPING.get((Object)type.withNullable(false));
        if (typeName == null) {
            typeName = BEAM_TO_CALCITE_DEFAULT_MAPPING.get(type);
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Cannot find a matching Calcite SqlTypeName for Beam type: %s", type));
        }
        return typeName;
    }

    public static Schema.FieldType toFieldType(SqlTypeNameSpec sqlTypeName) {
        return CalciteUtils.toFieldType((SqlTypeName)Preconditions.checkArgumentNotNull((Object)SqlTypeName.get((String)sqlTypeName.getTypeName().getSimple()), (String)"Failed to find Calcite type with name '%s'", (Object)sqlTypeName.getTypeName().getSimple()));
    }

    public static Schema.FieldType toFieldType(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case MAP: 
            case MULTISET: 
            case ARRAY: 
            case ROW: {
                throw new IllegalArgumentException(String.format("%s is a type constructor that takes parameters, not a type,so it cannot be converted to a %s", sqlTypeName, Schema.FieldType.class.getSimpleName()));
            }
        }
        Schema.FieldType fieldType = (Schema.FieldType)CALCITE_TO_BEAM_TYPE_MAPPING.get((Object)sqlTypeName);
        if (fieldType == null) {
            throw new IllegalArgumentException("Cannot find a matching Beam FieldType for Calcite type: " + sqlTypeName);
        }
        return fieldType;
    }

    public static Schema.Field toField(RelDataTypeField calciteField) {
        return CalciteUtils.toField(calciteField.getName(), calciteField.getType());
    }

    public static Schema.Field toField(String name, RelDataType calciteType) {
        return Schema.Field.of((String)name, (Schema.FieldType)CalciteUtils.toFieldType(calciteType)).withNullable(calciteType.isNullable());
    }

    public static Schema.FieldType toFieldType(RelDataType calciteType) {
        switch (calciteType.getSqlTypeName()) {
            case MULTISET: 
            case ARRAY: {
                return Schema.FieldType.array((Schema.FieldType)CalciteUtils.toFieldType((RelDataType)Preconditions.checkArgumentNotNull((Object)calciteType.getComponentType(), (Object)"Encountered MULTISET type with null component type")));
            }
            case MAP: {
                return Schema.FieldType.map((Schema.FieldType)CalciteUtils.toFieldType((RelDataType)Preconditions.checkArgumentNotNull((Object)calciteType.getKeyType(), (Object)"Encountered MAP type with null key type.")), (Schema.FieldType)CalciteUtils.toFieldType((RelDataType)Preconditions.checkArgumentNotNull((Object)calciteType.getValueType(), (Object)"Encountered MAP type with null value type.")));
            }
            case ROW: {
                return Schema.FieldType.row((Schema)CalciteUtils.toSchema(calciteType));
            }
        }
        try {
            return CalciteUtils.toFieldType(calciteType.getSqlTypeName()).withNullable(calciteType.isNullable());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find a matching Beam FieldType for Calcite type: " + calciteType, e);
        }
    }

    public static RelDataType toCalciteRowType(Schema schema, RelDataTypeFactory dataTypeFactory) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(dataTypeFactory);
        IntStream.range(0, schema.getFieldCount()).forEach(idx -> builder.add(schema.getField(idx).getName(), CalciteUtils.toRelDataType(dataTypeFactory, schema, idx)));
        return builder.build();
    }

    public static RelDataType toRelDataType(RelDataTypeFactory dataTypeFactory, Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                Schema.FieldType collectionElementType = fieldType.getCollectionElementType();
                Preconditions.checkArgumentNotNull((Object)collectionElementType);
                return dataTypeFactory.createArrayType(CalciteUtils.toRelDataType(dataTypeFactory, collectionElementType), -1L);
            }
            case MAP: {
                Schema.FieldType mapKeyType = fieldType.getMapKeyType();
                Schema.FieldType mapValueType = fieldType.getMapValueType();
                Preconditions.checkArgumentNotNull((Object)mapKeyType);
                Preconditions.checkArgumentNotNull((Object)mapValueType);
                RelDataType componentKeyType = CalciteUtils.toRelDataType(dataTypeFactory, mapKeyType);
                RelDataType componentValueType = CalciteUtils.toRelDataType(dataTypeFactory, mapValueType);
                return dataTypeFactory.createMapType(componentKeyType, componentValueType);
            }
            case ROW: {
                Schema schema = fieldType.getRowSchema();
                Preconditions.checkArgumentNotNull((Object)schema);
                return CalciteUtils.toCalciteRowType(schema, dataTypeFactory);
            }
        }
        return dataTypeFactory.createSqlType(CalciteUtils.toSqlTypeName(fieldType));
    }

    private static RelDataType toRelDataType(RelDataTypeFactory dataTypeFactory, Schema schema, int fieldIndex) {
        Schema.Field field = schema.getField(fieldIndex);
        RelDataType type = CalciteUtils.toRelDataType(dataTypeFactory, field.getType());
        return dataTypeFactory.createTypeWithNullability(type, field.getType().getNullable().booleanValue());
    }

    public static RelDataType sqlTypeWithAutoCast(RelDataTypeFactory typeFactory, Type type) {
        if (type instanceof Class && AbstractInstant.class.isAssignableFrom((Class)type)) {
            return typeFactory.createJavaType(Date.class);
        }
        if (type instanceof Class && ByteString.class.isAssignableFrom((Class)type)) {
            return typeFactory.createJavaType(byte[].class);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (List.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                RelDataType elementType = CalciteUtils.sqlTypeWithAutoCast(typeFactory, parameterizedType.getActualTypeArguments()[0]);
                return typeFactory.createArrayType(elementType, -1L);
            }
            if (Map.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                RelDataType mapElementKeyType = CalciteUtils.sqlTypeWithAutoCast(typeFactory, parameterizedType.getActualTypeArguments()[0]);
                RelDataType mapElementValueType = CalciteUtils.sqlTypeWithAutoCast(typeFactory, parameterizedType.getActualTypeArguments()[1]);
                return typeFactory.createMapType(mapElementKeyType, mapElementValueType);
            }
        } else if (type instanceof GenericArrayType) {
            throw new IllegalArgumentException("Cannot infer types from " + type + ". This is currently unsupported, use List instead of Array.");
        }
        return typeFactory.createJavaType((Class)type);
    }

    public static class CharType
    extends PassThroughLogicalType<String> {
        public static final String IDENTIFIER = "SqlCharType";

        public CharType() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.STRING);
        }
    }

    public static class TimeWithLocalTzType
    extends PassThroughLogicalType<Instant> {
        public static final String IDENTIFIER = "SqlTimeWithLocalTzType";

        public TimeWithLocalTzType() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.DATETIME);
        }
    }
}

