/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Set;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamJoinRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamJoinTransforms;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Join;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;

public class BeamSideInputLookupJoinRel
extends BeamJoinRel {
    public BeamSideInputLookupJoinRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        if (this.joinType == JoinRelType.FULL) {
            throw new UnsupportedOperationException("FULL OUTER JOIN is not supported when join a Seekable table with a non Seekable table.");
        }
        if (this.joinType == JoinRelType.LEFT && (Integer)this.seekableInputIndex().get() == 0 || this.joinType == JoinRelType.RIGHT && (Integer)this.seekableInputIndex().get() == 1) {
            throw new UnsupportedOperationException(String.format("%s side of an OUTER JOIN must be a non Seekable table.", this.joinType.name()));
        }
        return new SideInputLookupJoin();
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BeamSideInputLookupJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    private class SideInputLookupJoin
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private SideInputLookupJoin() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Schema schema = CalciteUtils.toSchema(BeamSideInputLookupJoinRel.this.getRowType());
            BeamRelNode seekableRel = BeamSqlRelUtils.getBeamRelInput(BeamSideInputLookupJoinRel.this.getInput((Integer)BeamSideInputLookupJoinRel.this.seekableInputIndex().get()));
            BeamRelNode nonSeekableRel = BeamSqlRelUtils.getBeamRelInput(BeamSideInputLookupJoinRel.this.getInput((Integer)BeamSideInputLookupJoinRel.this.nonSeekableInputIndex().get()));
            int factColOffset = (Integer)BeamSideInputLookupJoinRel.this.nonSeekableInputIndex().get() == 0 ? 0 : CalciteUtils.toSchema(seekableRel.getRowType()).getFieldCount();
            int lkpColOffset = (Integer)BeamSideInputLookupJoinRel.this.seekableInputIndex().get() == 0 ? 0 : CalciteUtils.toSchema(nonSeekableRel.getRowType()).getFieldCount();
            BeamIOSourceRel seekableInput = (BeamIOSourceRel)seekableRel;
            BeamSqlSeekableTable seekableTable = (BeamSqlSeekableTable)((Object)seekableInput.getBeamSqlTable());
            PCollection nonSeekableInput = pinput.get(0);
            return ((PCollection)nonSeekableInput.apply("join_as_lookup", (PTransform)new BeamJoinTransforms.JoinAsLookup(BeamSideInputLookupJoinRel.this.condition, seekableTable, CalciteUtils.toSchema(seekableInput.getRowType()), schema, factColOffset, lkpColOffset))).setRowSchema(schema);
        }
    }
}

