/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.parquet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.ProjectSupport;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class ParquetTable
extends SchemaBaseBeamTable
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetTable.class);
    private final Table table;

    ParquetTable(Table table) {
        super(table.getSchema());
        this.table = table;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        Schema schema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)this.table.getSchema());
        ParquetIO.Read read = ParquetIO.read((Schema)schema).withBeamSchemas(true).from(this.table.getLocation() + "/*");
        return (PCollection)((PCollection)begin.apply("ParquetIORead", (PTransform)read)).apply("ToRows", Convert.toRows());
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin, BeamSqlTableFilter filters, List<String> fieldNames) {
        Schema schema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)this.table.getSchema());
        ParquetIO.Read read = ParquetIO.read((Schema)schema).withBeamSchemas(true).from(this.table.getLocation() + "/*");
        if (!fieldNames.isEmpty()) {
            Schema projectionSchema = ParquetTable.projectSchema(schema, fieldNames);
            LOG.info("Projecting fields schema : " + projectionSchema.toString());
            read = read.withProjection(projectionSchema, projectionSchema);
        }
        return (PCollection)((PCollection)begin.apply("ParquetIORead", (PTransform)read)).apply("ToRows", Convert.toRows());
    }

    private static Schema projectSchema(Schema schema, List<String> fieldNames) {
        ArrayList<Schema.Field> selectedFields = new ArrayList<Schema.Field>();
        for (String fieldName : fieldNames) {
            selectedFields.add(ParquetTable.deepCopyField(schema.getField(fieldName)));
        }
        return Schema.createRecord((String)(schema.getName() + "_projected"), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), selectedFields);
    }

    private static Schema.Field deepCopyField(Schema.Field field) {
        Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal(), field.order());
        for (Map.Entry kv : field.getObjectProps().entrySet()) {
            newField.addProp((String)kv.getKey(), kv.getValue());
        }
        if (field.aliases() != null) {
            for (String alias : field.aliases()) {
                newField.addAlias(alias);
            }
        }
        return newField;
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        Schema schema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)input.getSchema());
        return ((PCollection)input.apply("ToGenericRecords", Convert.to(GenericRecord.class))).apply("ParquetIOWrite", (PTransform)FileIO.write().via((FileIO.Sink)ParquetIO.sink((Schema)schema)).to(this.table.getLocation()));
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.BOUNDED_UNKNOWN;
    }

    @Override
    public ProjectSupport supportsProjects() {
        return ProjectSupport.WITH_FIELD_REORDERING;
    }
}

