/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcFactory;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.AvaticaFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.Driver;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.CoreRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.Hook;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.codehaus.commons.compiler.CompilerFactoryFactory;

@AutoService(value={java.sql.Driver.class})
public class JdbcDriver
extends Driver {
    public static final JdbcDriver INSTANCE = new JdbcDriver();
    public static final String CONNECT_STRING_PREFIX = "jdbc:beam:";
    static final String TOP_LEVEL_BEAM_SCHEMA = "beam";
    public static final ObjectMapper OBJECT_MAPPER;

    protected AvaticaFactory createFactory() {
        return JdbcFactory.wrap((CalciteFactory)super.createFactory());
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        return JdbcConnection.initialize((CalciteConnection)super.connect(url, info));
    }

    public static JdbcConnection connect(TableProvider tableProvider, PipelineOptions options) {
        try {
            Properties properties = new Properties();
            properties.setProperty(CalciteConnectionProperty.SCHEMA_FACTORY.camelName(), BeamCalciteSchemaFactory.Empty.class.getName());
            JdbcConnection connection = (JdbcConnection)((Object)INSTANCE.connect(CONNECT_STRING_PREFIX, properties));
            connection.setSchema(TOP_LEVEL_BEAM_SCHEMA, tableProvider);
            connection.setPipelineOptions(options);
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JdbcDriver.class.getClassLoader());
            CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
        Hook.PLANNER.add(planner -> {
            for (RuleSet ruleSet : BeamRuleSets.getRuleSets()) {
                for (RelOptRule rule : ruleSet) {
                    planner.addRule(rule);
                }
            }
            planner.removeRule((RelOptRule)CoreRules.CALC_REMOVE);
            planner.removeRule((RelOptRule)CoreRules.SORT_REMOVE);
            for (RelOptRule rule : EnumerableRules.ENUMERABLE_RULES) {
                planner.removeRule(rule);
            }
            ArrayList relTraitDefs = new ArrayList(planner.getRelTraitDefs());
            planner.clearRelTraitDefs();
            for (RelTraitDef def : relTraitDefs) {
                if (def instanceof RelCollationTraitDef) continue;
                planner.addRelTraitDef(def);
            }
        });
        INSTANCE.register();
        OBJECT_MAPPER = new ObjectMapper();
    }
}

