/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.AutoValue_TextTableProvider_JsonToRow;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.AutoValue_TextTableProvider_RowToJson;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextJsonTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableSet;
import org.apache.commons.csv.CSVFormat;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public String getTableType() {
        return "text";
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        Schema schema = table.getSchema();
        String filePattern = table.getLocation();
        JSONObject properties = table.getProperties();
        String format = (String)MoreObjects.firstNonNull((Object)properties.getString("format"), (Object)"csv");
        String deadLetterFile = properties.getString("deadLetterFile");
        String legacyCsvFormat = null;
        if (!ImmutableSet.of((Object)"csv", (Object)"lines", (Object)"json").contains((Object)format)) {
            legacyCsvFormat = format;
            format = "csv";
        }
        switch (format) {
            case "csv": {
                String specifiedCsvFormat = properties.getString("csvformat");
                CSVFormat csvFormat = specifiedCsvFormat != null ? CSVFormat.valueOf((String)specifiedCsvFormat) : (legacyCsvFormat != null ? CSVFormat.valueOf((String)legacyCsvFormat) : CSVFormat.DEFAULT);
                return new TextTable(schema, filePattern, new CsvToRow(schema, csvFormat), new RowToCsv(csvFormat));
            }
            case "json": {
                return new TextJsonTable(schema, filePattern, JsonToRow.create(schema, deadLetterFile), RowToJson.create());
            }
            case "lines": {
                if (schema.getFieldCount() != 1 || !schema.getField(0).getType().getTypeName().equals((Object)Schema.TypeName.STRING)) {
                    throw new InvalidTableException("Table with type 'text' and format 'lines' must have exactly one STRING/VARCHAR/CHAR column ");
                }
                return new TextTable(schema, filePattern, new LinesReadConverter(), new LinesWriteConverter());
            }
        }
        throw new InvalidTableException("Table with type 'text' must have format 'csv' or 'lines' or 'json'");
    }

    @VisibleForTesting
    public static class CsvToRow
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        private Schema schema;
        private CSVFormat csvFormat;

        @VisibleForTesting
        public CSVFormat getCsvFormat() {
            return this.csvFormat;
        }

        public CsvToRow(Schema schema, CSVFormat csvFormat) {
            this.schema = schema;
            this.csvFormat = csvFormat;
        }

        public PCollection<Row> expand(PCollection<String> input) {
            return ((PCollection)input.apply("csvToRow", (PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)s -> BeamTableUtils.csvLines2BeamRows(this.csvFormat, s, this.schema)))).setRowSchema(this.schema);
        }
    }

    @VisibleForTesting
    static class RowToCsv
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        private CSVFormat csvFormat;

        public RowToCsv(CSVFormat csvFormat) {
            this.csvFormat = csvFormat;
        }

        @VisibleForTesting
        public CSVFormat getCsvFormat() {
            return this.csvFormat;
        }

        public PCollection<String> expand(PCollection<Row> input) {
            return (PCollection)input.apply("rowToCsv", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> BeamTableUtils.beamRow2CsvLine(row, this.csvFormat)));
        }
    }

    @AutoValue
    @Internal
    static abstract class RowToJson
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        RowToJson() {
        }

        public static RowToJson create() {
            return new AutoValue_TextTableProvider_RowToJson();
        }

        public PCollection<String> expand(PCollection<Row> input) {
            return (PCollection)input.apply((PTransform)ToJson.of());
        }
    }

    @AutoValue
    @Internal
    static abstract class JsonToRow
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        protected static final TupleTag<String> DLF_TAG = new TupleTag();
        protected static final TupleTag<Row> MAIN_TAG = new TupleTag();

        JsonToRow() {
        }

        public abstract Schema schema();

        public abstract @Nullable String deadLetterFile();

        public static JsonToRow create(Schema schema, @Nullable String deadLetterFile) {
            return new AutoValue_TextTableProvider_JsonToRow(schema, deadLetterFile);
        }

        public static JsonToRow create(Schema schema) {
            return JsonToRow.create(schema, null);
        }

        public PCollection<Row> expand(PCollection<String> input) {
            PCollectionTuple rows = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, Row>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    try {
                        context.output((Object)RowJsonUtils.jsonToRow((ObjectMapper)this.getObjectMapper(), (String)((String)context.element())));
                    }
                    catch (RowJson.UnsupportedRowJsonException jsonException) {
                        if (this.deadLetterFile() != null) {
                            context.output(DLF_TAG, (Object)((String)context.element()));
                        }
                        throw new RuntimeException("Error parsing JSON", jsonException);
                    }
                }
            }).withOutputTags(MAIN_TAG, this.deadLetterFile() != null ? TupleTagList.of(DLF_TAG) : TupleTagList.empty()));
            if (this.deadLetterFile() != null) {
                rows.get(DLF_TAG).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)this.writeJsonToDlf());
            }
            return rows.get(MAIN_TAG).setRowSchema(this.schema());
        }

        private TextIO.Write writeJsonToDlf() {
            return TextIO.write().withDelimiter(new char[0]).to(this.deadLetterFile());
        }

        private ObjectMapper getObjectMapper() {
            return RowJsonUtils.newObjectMapperWith((RowJson.RowJsonDeserializer)RowJson.RowJsonDeserializer.forSchema((Schema)this.schema()));
        }
    }

    public static class LinesReadConverter
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        private static final Schema SCHEMA = Schema.builder().addStringField("line").build();

        public PCollection<Row> expand(PCollection<String> input) {
            return ((PCollection)input.apply("linesToRows", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)s -> Row.withSchema((Schema)SCHEMA).addValue(s).build()))).setRowSchema(SCHEMA);
        }
    }

    public static class LinesWriteConverter
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        public PCollection<String> expand(PCollection<Row> input) {
            return (PCollection)input.apply("rowsToLines", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> row.getString(0) + "\n"));
        }
    }
}

