/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BeamUnnestRel
extends Uncollect
implements BeamRelNode {
    private final RelDataType unnestType;
    private final List<Integer> unnestIndices;

    public BeamUnnestRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType unnestType, List<Integer> unnestIndices) {
        super(cluster, traitSet, input);
        this.unnestType = unnestType;
        this.unnestIndices = unnestIndices;
    }

    public Uncollect copy(RelTraitSet traitSet, RelNode input) {
        return new BeamUnnestRel(this.getCluster(), traitSet, input, this.unnestType, this.unnestIndices);
    }

    protected RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.input.getRowType(), (RelDataType)this.unnestType, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, (List)ImmutableList.of());
    }

    @Override
    public NodeStats estimateNodeStats(BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq).multiply(2.0);
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, BeamRelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats(this, mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("unnestIndices", this.unnestIndices);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static class UnnestFn
    extends DoFn<Row, Row> {
        private final Schema outputSchema;
        private final List<Integer> unnestIndices;

        private UnnestFn(Schema outputSchema, List<Integer> unnestIndices) {
            this.outputSchema = outputSchema;
            this.unnestIndices = unnestIndices;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> out) {
            Row rowWithArrayField = row;
            Schema schemaWithArrayField = this.outputSchema;
            for (int i = this.unnestIndices.size() - 1; i > 0; --i) {
                rowWithArrayField = rowWithArrayField.getRow(this.unnestIndices.get(i).intValue());
                schemaWithArrayField = schemaWithArrayField.getField(this.unnestIndices.get(i).intValue()).getType().getRowSchema();
            }
            @Nullable Collection rawValues = rowWithArrayField.getArray(this.unnestIndices.get(0).intValue());
            if (rawValues == null) {
                return;
            }
            Schema.TypeName typeName = schemaWithArrayField.getField(this.unnestIndices.get(0).intValue()).getType().getCollectionElementType().getTypeName();
            for (Object uncollectedValue : rawValues) {
                if (typeName.equals((Object)Schema.TypeName.ROW)) {
                    Row nestedRow = (Row)uncollectedValue;
                    out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValues(nestedRow.getBaseValues()).build());
                    continue;
                }
                out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValue(uncollectedValue).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            PCollection outer = pinput.get(0);
            Schema joinedSchema = CalciteUtils.toSchema(BeamUnnestRel.this.getRowType());
            return ((PCollection)outer.apply((PTransform)ParDo.of((DoFn)new UnnestFn(joinedSchema, BeamUnnestRel.this.unnestIndices)))).setRowSchema(joinedSchema);
        }
    }
}

