/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOSinkRule;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.RenameFields;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.Prepare;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql2rel.RelStructuredTypeFlattener;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BeamIOSinkRel
extends TableModify
implements BeamRelNode,
RelStructuredTypeFlattener.SelfFlatteningRel {
    private final BeamSqlTable sqlTable;
    private final Map<String, String> pipelineOptions;
    private boolean isFlattening = false;

    public BeamIOSinkRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, @Nullable List<String> updateColumnList, @Nullable List<RexNode> sourceExpressionList, boolean flattened, BeamSqlTable sqlTable, Map<String, String> pipelineOptions) {
        super(cluster, cluster.traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        this.sqlTable = sqlTable;
        this.pipelineOptions = pipelineOptions;
    }

    @Override
    public NodeStats estimateNodeStats(BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq);
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, BeamRelMetadataQuery mq) {
        NodeStats inputEstimates = BeamSqlRelUtils.getNodeStats(this.input, mq);
        return BeamCostModel.FACTORY.makeCost(inputEstimates.getRowCount(), inputEstimates.getRate());
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        boolean flattened = this.isFlattened() || this.isFlattening;
        BeamIOSinkRel newRel = new BeamIOSinkRel(this.getCluster(), this.getTable(), this.getCatalogReader(), (RelNode)BeamIOSinkRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), flattened, this.sqlTable, this.pipelineOptions);
        newRel.traitSet = traitSet;
        return newRel;
    }

    public void flattenRel(RelStructuredTypeFlattener flattener) {
        this.isFlattening = true;
        flattener.rewriteGeneric((RelNode)this);
        this.isFlattening = false;
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)BeamIOSinkRule.INSTANCE);
        super.register(planner);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public Map<String, String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamIOSinkRel.class.getSimpleName(), pinput);
            Schema schema = CalciteUtils.toSchema(BeamIOSinkRel.this.getExpectedInputRowType(0));
            PCollection input = ((PCollection)pinput.get(0).apply((PTransform)RenameFields.create())).setRowSchema(schema);
            BeamIOSinkRel.this.sqlTable.buildIOWriter((PCollection<Row>)input);
            return input;
        }
    }
}

