/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamAggregationRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Project;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

public class BeamAggregationRule
extends RelOptRule {
    public static final BeamAggregationRule INSTANCE = new BeamAggregationRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public BeamAggregationRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        super(BeamAggregationRule.operand(aggregateClass, (RelOptRuleOperand)BeamAggregationRule.operand(projectClass, (RelOptRuleOperandChildren)BeamAggregationRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Project project = (Project)call.rel(1);
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return;
        }
        RelNode x = BeamAggregationRule.updateWindow(call, aggregate, project);
        if (x == null) {
            return;
        }
        call.transformTo(x);
    }

    private static RelNode updateWindow(RelOptRuleCall call, Aggregate aggregate, Project project) {
        ImmutableBitSet groupByFields = aggregate.getGroupSet();
        ArrayList<RexNode> projects = new ArrayList<RexNode>(project.getProjects());
        WindowFn windowFn = null;
        int windowFieldIndex = -1;
        Iterator iterator = groupByFields.asList().iterator();
        while (iterator.hasNext()) {
            RexCall rexCall;
            WindowFn fn;
            int groupFieldIndex = (Integer)iterator.next();
            RexNode projNode = (RexNode)projects.get(groupFieldIndex);
            if (!(projNode instanceof RexCall) || (fn = BeamAggregationRule.createWindowFn((rexCall = (RexCall)projNode).getOperands(), rexCall.op.kind)) == null) continue;
            windowFn = fn;
            windowFieldIndex = groupFieldIndex;
            projects.set(groupFieldIndex, (RexNode)rexCall.getOperands().get(0));
        }
        if (windowFn == null) {
            return null;
        }
        Project newProject = project.copy(project.getTraitSet(), project.getInput(), projects, project.getRowType());
        return new BeamAggregationRel(aggregate.getCluster(), aggregate.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE), BeamAggregationRule.convert((RelNode)newProject, (RelTraitSet)newProject.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE)), aggregate.getGroupSet(), (List<ImmutableBitSet>)aggregate.getGroupSets(), aggregate.getAggCallList(), (WindowFn<Row, IntervalWindow>)windowFn, windowFieldIndex);
    }

    private static @Nullable WindowFn createWindowFn(List<RexNode> parameters, SqlKind operatorKind) {
        switch (operatorKind) {
            case TUMBLE: {
                FixedWindows fixedWindows = FixedWindows.of((Duration)BeamAggregationRule.durationParameter(parameters, 1));
                if (parameters.size() == 3) {
                    fixedWindows = fixedWindows.withOffset(BeamAggregationRule.durationParameter(parameters, 2));
                }
                return fixedWindows;
            }
            case HOP: {
                SlidingWindows slidingWindows = SlidingWindows.of((Duration)BeamAggregationRule.durationParameter(parameters, 2)).every(BeamAggregationRule.durationParameter(parameters, 1));
                if (parameters.size() == 4) {
                    slidingWindows = slidingWindows.withOffset(BeamAggregationRule.durationParameter(parameters, 3));
                }
                return slidingWindows;
            }
            case SESSION: {
                Sessions sessions = Sessions.withGapDuration((Duration)BeamAggregationRule.durationParameter(parameters, 1));
                if (parameters.size() == 3) {
                    throw new UnsupportedOperationException("Specifying alignment (offset) is not supported for session windows");
                }
                return sessions;
            }
        }
        return null;
    }

    private static Duration durationParameter(List<RexNode> parameters, int parameterIndex) {
        return Duration.millis((long)BeamAggregationRule.longValue(parameters.get(parameterIndex)));
    }

    private static long longValue(RexNode operand) {
        if (operand instanceof RexLiteral) {
            return ((Number)((Object)RexLiteral.value((RexNode)operand))).longValue();
        }
        throw new IllegalArgumentException(String.format("[%s] is not valid.", operand));
    }
}

