/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.vendor.calcite.v1_26_0.com.google.common.collect.ImmutableMap;

public class InMemoryMetaStore
implements MetaStore {
    private Map<String, Table> tables = new HashMap<String, Table>();
    private Map<String, TableProvider> providers = new HashMap<String, TableProvider>();

    @Override
    public String getTableType() {
        return "store";
    }

    @Override
    public void createTable(Table table) {
        this.validateTableType(table);
        if (this.tables.containsKey(table.getName())) {
            throw new IllegalArgumentException("Duplicate table name: " + table.getName());
        }
        this.providers.get(table.getType()).createTable(table);
        this.tables.put(table.getName(), table);
    }

    @Override
    public void dropTable(String tableName) {
        if (!this.tables.containsKey(tableName)) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        Table table = this.tables.get(tableName);
        this.providers.get(table.getType()).dropTable(tableName);
        this.tables.remove(tableName);
    }

    @Override
    public Map<String, Table> getTables() {
        return ImmutableMap.copyOf(this.tables);
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        TableProvider provider = this.providers.get(table.getType());
        return provider.buildBeamSqlTable(table);
    }

    private void validateTableType(Table table) {
        if (!this.providers.containsKey(table.getType())) {
            throw new IllegalArgumentException("Table type: " + table.getType() + " not supported!");
        }
    }

    @Override
    public void registerProvider(TableProvider provider) {
        if (this.providers.containsKey(provider.getTableType())) {
            throw new IllegalArgumentException("Provider is already registered for table type: " + provider.getTableType());
        }
        this.initTablesFromProvider(provider);
        this.providers.put(provider.getTableType(), provider);
    }

    private void initTablesFromProvider(TableProvider provider) {
        Map<String, Table> tables = provider.getTables();
        for (String tableName : tables.keySet()) {
            if (!this.tables.containsKey(tableName)) continue;
            throw new IllegalStateException("Duplicate table: " + tableName + " from provider: " + provider);
        }
        this.tables.putAll(tables);
    }

    Map<String, TableProvider> getProviders() {
        return this.providers;
    }
}

