/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udaf;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Combine;

@Experimental
public class StringAgg {

    public static class StringAggString
    extends Combine.CombineFn<String, String, String> {
        private static final String delimiter = ",";

        public String createAccumulator() {
            return "";
        }

        public String addInput(String curString, String nextString) {
            if (!nextString.isEmpty()) {
                curString = !curString.isEmpty() ? curString + delimiter + nextString : nextString;
            }
            return curString;
        }

        public String mergeAccumulators(Iterable<String> accumList) {
            String mergeString = "";
            for (String stringAccum : accumList) {
                if (stringAccum.isEmpty()) continue;
                if (!mergeString.isEmpty()) {
                    mergeString = mergeString + delimiter + stringAccum;
                    continue;
                }
                mergeString = stringAccum;
            }
            return mergeString;
        }

        public String extractOutput(String output) {
            return output;
        }
    }
}

