/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPKind;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperator;
import org.apache.beam.sdk.extensions.sql.impl.cep.Quantifier;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;

public class CEPPattern
implements Serializable {
    private final Schema mySchema;
    private final String patternVar;
    private final CEPCall patternCondition;
    private final Quantifier quant;

    private CEPPattern(Schema mySchema, String patternVar, @Nullable RexCall patternDef, Quantifier quant) {
        this.mySchema = mySchema;
        this.patternVar = patternVar;
        this.quant = quant;
        if (patternDef == null) {
            this.patternCondition = null;
            return;
        }
        this.patternCondition = CEPCall.of(patternDef);
    }

    private int evalOperation(CEPCall operation, CEPLiteral lit, Row rowEle) {
        CEPOperator call = operation.getOperator();
        List<CEPOperation> operands = operation.getOperands();
        if (call.getCepKind() == CEPKind.LAST) {
            CEPOperation opr0 = operands.get(0);
            CEPLiteral opr1 = (CEPLiteral)operands.get(1);
            if (opr0.getClass() == CEPFieldRef.class && opr1.getDecimal().equals(BigDecimal.ZERO)) {
                int fIndex = ((CEPFieldRef)opr0).getIndex();
                Schema.Field fd = this.mySchema.getField(fIndex);
                Schema.FieldType dtype = fd.getType();
                switch (dtype.getTypeName()) {
                    case BYTE: {
                        return rowEle.getByte(fIndex).compareTo(lit.getByte());
                    }
                    case INT16: {
                        return rowEle.getInt16(fIndex).compareTo(lit.getInt16());
                    }
                    case INT32: {
                        return rowEle.getInt32(fIndex).compareTo(lit.getInt32());
                    }
                    case INT64: {
                        return rowEle.getInt64(fIndex).compareTo(lit.getInt64());
                    }
                    case DECIMAL: {
                        return rowEle.getDecimal(fIndex).compareTo(lit.getDecimal());
                    }
                    case FLOAT: {
                        return rowEle.getFloat(fIndex).compareTo(lit.getFloat());
                    }
                    case DOUBLE: {
                        return rowEle.getDouble(fIndex).compareTo(lit.getDouble());
                    }
                    case STRING: {
                        return rowEle.getString(fIndex).compareTo(lit.getString());
                    }
                    case DATETIME: {
                        return rowEle.getDateTime(fIndex).compareTo((Object)lit.getDateTime());
                    }
                    case BOOLEAN: {
                        return rowEle.getBoolean(fIndex).compareTo(lit.getBoolean());
                    }
                }
                throw new UnsupportedOperationException("Specified column not comparable: " + fd.getName());
            }
        }
        throw new UnsupportedOperationException("backward functions (PREV, NEXT) not supported for now");
    }

    public String toString() {
        return this.patternVar + this.quant.toString();
    }

    public CEPCall getPatternCondition() {
        return this.patternCondition;
    }

    public String getPatternVar() {
        return this.patternVar;
    }

    public Quantifier getQuantifier() {
        return this.quant;
    }

    public static CEPPattern of(Schema theSchema, String patternVar, RexCall patternDef, Quantifier quant) {
        return new CEPPattern(theSchema, patternVar, patternDef, quant);
    }
}

