/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun;

import java.math.BigDecimal;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlMonotonicBinaryOperator
extends SqlBinaryOperator {
    public SqlMonotonicBinaryOperator(String name, SqlKind kind, int prec, boolean isLeftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, prec, isLeftAssoc, returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        SqlMonotonicity mono0 = call.getOperandMonotonicity(0);
        SqlMonotonicity mono1 = call.getOperandMonotonicity(1);
        if (mono1 == SqlMonotonicity.CONSTANT && mono0 == SqlMonotonicity.CONSTANT) {
            return SqlMonotonicity.CONSTANT;
        }
        if (mono1 == SqlMonotonicity.CONSTANT) {
            if (this.getName().equals("-") || this.getName().equals("+")) {
                return mono0;
            }
            assert (this.getName().equals("*"));
            switch (this.signum(call.getOperandLiteralValue(1))) {
                case -1: {
                    return mono0.reverse();
                }
                case 0: {
                    return SqlMonotonicity.CONSTANT;
                }
            }
            return mono0;
        }
        if (mono0 == SqlMonotonicity.CONSTANT) {
            if (this.getName().equals("-")) {
                return mono1.reverse();
            }
            if (this.getName().equals("+")) {
                return mono1;
            }
            assert (this.getName().equals("*"));
            Comparable v0 = call.getOperandLiteralValue(0);
            if (v0 != null) {
                switch (this.signum(v0)) {
                    case -1: {
                        return mono1.reverse();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono1;
            }
        }
        if (this.getName().equals("+")) {
            if (mono0 == mono1) {
                return mono0;
            }
            if (mono0.unstrict() == mono1.unstrict()) {
                return mono0.unstrict();
            }
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (this.getName().equals("-")) {
            if (mono0 == mono1.reverse()) {
                return mono0;
            }
            if (mono0.unstrict() == mono1.reverse().unstrict()) {
                return mono0.unstrict();
            }
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (this.getName().equals("*")) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return super.getMonotonicity(call);
    }

    private int signum(Object o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).signum();
        }
        if (o instanceof SqlIntervalLiteral.IntervalValue) {
            return ((SqlIntervalLiteral.IntervalValue)o).getSign();
        }
        return 1;
    }
}

