/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql;

import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Ord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlReturnTypeInference;

public class SqlInfixOperator
extends SqlSpecialOperator {
    private final String[] names;

    protected SqlInfixOperator(String[] names, SqlKind kind, int precedence, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(names[0], kind, precedence, true, returnTypeInference, operandTypeInference, operandTypeChecker);
        assert (names.length > 1);
        this.names = names;
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == this.names.length + 1);
        boolean needWhitespace = this.needsSpace();
        for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
            if (operand.i > 0) {
                writer.setNeedWhitespace(needWhitespace);
                writer.keyword(this.names[operand.i - 1]);
                writer.setNeedWhitespace(needWhitespace);
            }
            ((SqlNode)operand.e).unparse(writer, leftPrec, this.getLeftPrec());
        }
    }
}

