/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Lists;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.AbstractEnumerable2;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.CartesianProductEnumerator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Enumerator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.QueryProviderImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Queryable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.TransformedEnumerator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.function.Function1;

public abstract class Linq4j {
    private static final Object DUMMY = new Object();
    public static final QueryProvider DEFAULT_PROVIDER = new QueryProviderImpl(){

        @Override
        public <T> Enumerator<T> executeQuery(Queryable<T> queryable) {
            return queryable.enumerator();
        }
    };
    private static final Enumerator<Object> EMPTY_ENUMERATOR = new Enumerator<Object>(){

        @Override
        public Object current() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean moveNext() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public void close() {
        }
    };
    public static final Enumerable<?> EMPTY_ENUMERABLE = new AbstractEnumerable<Object>(){

        @Override
        public Enumerator<Object> enumerator() {
            return EMPTY_ENUMERATOR;
        }
    };

    private Linq4j() {
    }

    public static Method getMethod(String className, String methodName, Class ... parameterTypes) {
        try {
            return Class.forName(className).getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Iterator<T> enumeratorIterator(Enumerator<T> enumerator) {
        return new EnumeratorIterator<T>(enumerator);
    }

    public static <T> Enumerator<T> iterableEnumerator(Iterable<? extends T> iterable) {
        if (iterable instanceof Enumerable) {
            Enumerable enumerable = (Enumerable)iterable;
            return enumerable.enumerator();
        }
        return new IterableEnumerator<T>(iterable);
    }

    public static <T> Enumerable<T> asEnumerable(List<T> list) {
        return new ListEnumerable<T>(list);
    }

    public static <T> Enumerable<T> asEnumerable(Collection<T> collection) {
        if (collection instanceof List) {
            return Linq4j.asEnumerable((List)collection);
        }
        return new CollectionEnumerable<T>(collection);
    }

    public static <T> Enumerable<T> asEnumerable(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return Linq4j.asEnumerable((Collection)iterable);
        }
        return new IterableEnumerable<T>(iterable);
    }

    public static <T> Enumerable<T> asEnumerable(T[] ts) {
        return new ListEnumerable<T>(Arrays.asList(ts));
    }

    public static <V> Enumerator<V> enumerator(Collection<? extends V> values) {
        if (values instanceof List && values instanceof RandomAccess) {
            return Linq4j.listEnumerator((List)values);
        }
        return Linq4j.iterableEnumerator(values);
    }

    private static <V> Enumerator<V> listEnumerator(List<? extends V> list) {
        return new ListEnumerator<V>(list);
    }

    public static <F, E> Enumerator<E> transform(Enumerator<F> enumerator, final Function1<F, E> func) {
        return new TransformedEnumerator<F, E>(enumerator){

            @Override
            protected E transform(F from) {
                return func.apply(from);
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> cast(Iterable<TSource> source, Class<TResult> clazz) {
        return Linq4j.asEnumerable(source).cast(clazz);
    }

    public static <TSource, TResult> Enumerable<TResult> ofType(Iterable<TSource> source, Class<TResult> clazz) {
        return Linq4j.asEnumerable(source).ofType(clazz);
    }

    public static <T> Enumerable<T> singletonEnumerable(final T element) {
        return new AbstractEnumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                return Linq4j.singletonEnumerator(element);
            }
        };
    }

    public static <T> Enumerator<T> singletonEnumerator(T element) {
        return new SingletonEnumerator<T>(element);
    }

    public static <T> Enumerator<T> singletonNullEnumerator() {
        return new SingletonNullEnumerator();
    }

    public static <T> Enumerable<T> emptyEnumerable() {
        return EMPTY_ENUMERABLE;
    }

    public static <T> Enumerator<T> emptyEnumerator() {
        return EMPTY_ENUMERATOR;
    }

    public static <E> Enumerable<E> concat(List<Enumerable<E>> enumerableList) {
        return new CompositeEnumerable<E>(enumerableList);
    }

    public static <T> Enumerator<List<T>> product(List<Enumerator<T>> enumerators) {
        return new CartesianProductListEnumerator(enumerators);
    }

    public static <T> Iterable<List<T>> product(final Iterable<? extends Iterable<T>> iterables) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                ArrayList enumerators = Lists.newArrayList();
                for (Iterable iterable : iterables) {
                    enumerators.add(Linq4j.iterableEnumerator(iterable));
                }
                return Linq4j.enumeratorIterator(new CartesianProductListEnumerator(enumerators));
            }
        };
    }

    @Deprecated
    public static <T> boolean equals(T t0, T t1) {
        return t0 == t1 || t0 != null && t0.equals(t1);
    }

    @Deprecated
    public static <T> T requireNonNull(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    private static <T> void closeIterator(Iterator<T> iterator) {
        if (iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CartesianProductListEnumerator<E>
    extends CartesianProductEnumerator<E, List<E>> {
        CartesianProductListEnumerator(List<Enumerator<E>> enumerators) {
            super(enumerators);
        }

        @Override
        public List<E> current() {
            return Arrays.asList((Object[])this.elements.clone());
        }
    }

    private static class ListEnumerator<V>
    implements Enumerator<V> {
        private final List<? extends V> list;
        int i = -1;

        ListEnumerator(List<? extends V> list) {
            this.list = list;
        }

        @Override
        public V current() {
            return this.list.get(this.i);
        }

        @Override
        public boolean moveNext() {
            return ++this.i < this.list.size();
        }

        @Override
        public void reset() {
            this.i = -1;
        }

        @Override
        public void close() {
        }
    }

    private static class EnumeratorIterator<T>
    implements Iterator<T>,
    AutoCloseable {
        private final Enumerator<T> enumerator;
        boolean hasNext;

        EnumeratorIterator(Enumerator<T> enumerator) {
            this.enumerator = enumerator;
            this.hasNext = enumerator.moveNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            T t = this.enumerator.current();
            this.hasNext = this.enumerator.moveNext();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    private static class SingletonNullEnumerator<E>
    implements Enumerator<E> {
        int i = 0;

        private SingletonNullEnumerator() {
        }

        @Override
        public E current() {
            return null;
        }

        @Override
        public boolean moveNext() {
            return this.i++ == 0;
        }

        @Override
        public void reset() {
            this.i = 0;
        }

        @Override
        public void close() {
        }
    }

    private static class SingletonEnumerator<E>
    implements Enumerator<E> {
        final E e;
        int i = 0;

        SingletonEnumerator(E e) {
            this.e = e;
        }

        @Override
        public E current() {
            return this.e;
        }

        @Override
        public boolean moveNext() {
            return this.i++ == 0;
        }

        @Override
        public void reset() {
            this.i = 0;
        }

        @Override
        public void close() {
        }
    }

    static class ListEnumerable<T>
    extends CollectionEnumerable<T> {
        ListEnumerable(List<T> list) {
            super(list);
        }

        @Override
        public Enumerator<T> enumerator() {
            if (this.iterable instanceof RandomAccess) {
                return new ListEnumerator((List)this.iterable);
            }
            return super.enumerator();
        }

        @Override
        public List<T> toList() {
            return (List)this.iterable;
        }

        @Override
        public Enumerable<T> skip(int count) {
            List<T> list = this.toList();
            if (count >= list.size()) {
                return Linq4j.emptyEnumerable();
            }
            return new ListEnumerable<T>(list.subList(count, list.size()));
        }

        @Override
        public Enumerable<T> take(int count) {
            List<T> list = this.toList();
            if (count >= list.size()) {
                return this;
            }
            return new ListEnumerable<T>(list.subList(0, count));
        }

        @Override
        public T elementAt(int index) {
            return this.toList().get(index);
        }
    }

    static class CollectionEnumerable<T>
    extends IterableEnumerable<T> {
        CollectionEnumerable(Collection<T> iterable) {
            super(iterable);
        }

        protected Collection<T> getCollection() {
            return (Collection)this.iterable;
        }

        @Override
        public int count() {
            return this.getCollection().size();
        }

        @Override
        public long longCount() {
            return this.getCollection().size();
        }

        @Override
        public boolean contains(T element) {
            return this.getCollection().contains(element);
        }

        @Override
        public boolean any() {
            return !this.getCollection().isEmpty();
        }
    }

    static class IterableEnumerable<T>
    extends AbstractEnumerable2<T> {
        protected final Iterable<T> iterable;

        IterableEnumerable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterable.iterator();
        }

        @Override
        public boolean any() {
            return this.iterable.iterator().hasNext();
        }
    }

    static class CompositeEnumerable<E>
    extends AbstractEnumerable<E> {
        private final Enumerator<Enumerable<E>> enumerableEnumerator;

        CompositeEnumerable(List<Enumerable<E>> enumerableList) {
            this.enumerableEnumerator = Linq4j.iterableEnumerator(enumerableList);
        }

        @Override
        public Enumerator<E> enumerator() {
            return new Enumerator<E>(){
                Enumerator<E> current = Linq4j.emptyEnumerator();

                @Override
                public E current() {
                    return this.current.current();
                }

                @Override
                public boolean moveNext() {
                    while (!this.current.moveNext()) {
                        this.current.close();
                        if (!CompositeEnumerable.this.enumerableEnumerator.moveNext()) {
                            this.current = Linq4j.emptyEnumerator();
                            return false;
                        }
                        this.current = ((Enumerable)CompositeEnumerable.this.enumerableEnumerator.current()).enumerator();
                    }
                    return true;
                }

                @Override
                public void reset() {
                    CompositeEnumerable.this.enumerableEnumerator.reset();
                    this.current = Linq4j.emptyEnumerator();
                }

                @Override
                public void close() {
                    this.current.close();
                    this.current = Linq4j.emptyEnumerator();
                }
            };
        }
    }

    static class IterableEnumerator<T>
    implements Enumerator<T> {
        private final Iterable<? extends T> iterable;
        Iterator<? extends T> iterator;
        T current;

        IterableEnumerator(Iterable<? extends T> iterable) {
            this.iterable = iterable;
            this.iterator = iterable.iterator();
            this.current = DUMMY;
        }

        @Override
        public T current() {
            if (this.current == DUMMY) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public boolean moveNext() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            this.current = DUMMY;
            return false;
        }

        @Override
        public void reset() {
            this.iterator = this.iterable.iterator();
            this.current = DUMMY;
        }

        @Override
        public void close() {
            Iterator<? extends T> iterator1 = this.iterator;
            this.iterator = null;
            Linq4j.closeIterator(iterator1);
        }
    }
}

