/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.Iterator;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSetOperatorRelBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TupleTag;

public abstract class BeamSetOperatorsTransforms {

    public static class SetOperatorFilteringDoFn
    extends DoFn<KV<BeamRecord, CoGbkResult>, BeamRecord> {
        private TupleTag<BeamRecord> leftTag;
        private TupleTag<BeamRecord> rightTag;
        private BeamSetOperatorRelBase.OpType opType;
        private boolean all;

        public SetOperatorFilteringDoFn(TupleTag<BeamRecord> leftTag, TupleTag<BeamRecord> rightTag, BeamSetOperatorRelBase.OpType opType, boolean all) {
            this.leftTag = leftTag;
            this.rightTag = rightTag;
            this.opType = opType;
            this.all = all;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            CoGbkResult coGbkResult = (CoGbkResult)((KV)ctx.element()).getValue();
            Iterable leftRows = coGbkResult.getAll(this.leftTag);
            Iterable rightRows = coGbkResult.getAll(this.rightTag);
            switch (this.opType) {
                case UNION: {
                    if (this.all) {
                        Iterator iter = leftRows.iterator();
                        while (iter.hasNext()) {
                            ctx.output(iter.next());
                        }
                        iter = rightRows.iterator();
                        while (iter.hasNext()) {
                            ctx.output(iter.next());
                        }
                        break;
                    }
                    ctx.output(((KV)ctx.element()).getKey());
                    break;
                }
                case INTERSECT: {
                    if (!leftRows.iterator().hasNext() || !rightRows.iterator().hasNext()) break;
                    if (this.all) {
                        for (BeamRecord leftRow : leftRows) {
                            ctx.output((Object)leftRow);
                        }
                        break;
                    }
                    ctx.output(((KV)ctx.element()).getKey());
                    break;
                }
                case MINUS: {
                    if (!leftRows.iterator().hasNext() || rightRows.iterator().hasNext()) break;
                    Iterator iter = leftRows.iterator();
                    if (this.all) {
                        while (iter.hasNext()) {
                            ctx.output(iter.next());
                        }
                        break;
                    }
                    ctx.output(iter.next());
                }
            }
        }
    }

    public static class BeamSqlRow2KvFn
    extends SimpleFunction<BeamRecord, KV<BeamRecord, BeamRecord>> {
        public KV<BeamRecord, BeamRecord> apply(BeamRecord input) {
            return KV.of((Object)input, (Object)input);
        }
    }
}

