/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.ArrayList;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Values;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexLiteral;

public class BeamValuesRel
extends Values
implements BeamRelNode {
    public BeamValuesRel(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, rowType, tuples, traits);
    }

    @Override
    public PCollection<BeamRecord> buildBeamPipeline(PCollectionTuple inputPCollections, BeamSqlEnv sqlEnv) throws Exception {
        ArrayList<BeamRecord> rows = new ArrayList<BeamRecord>(this.tuples.size());
        String stageName = BeamSqlRelUtils.getStageName(this);
        if (this.tuples.isEmpty()) {
            throw new IllegalStateException("Values with empty tuples!");
        }
        BeamRecordSqlType beamSQLRowType = CalciteUtils.toBeamRowType(this.getRowType());
        for (ImmutableList tuple : this.tuples) {
            ArrayList<Object> fieldsValue = new ArrayList<Object>(beamSQLRowType.getFieldCount());
            for (int i = 0; i < tuple.size(); ++i) {
                fieldsValue.add(BeamTableUtils.autoCastField(beamSQLRowType.getFieldTypeByIndex(i), ((RexLiteral)tuple.get(i)).getValue()));
            }
            rows.add(new BeamRecord((BeamRecordType)beamSQLRowType, fieldsValue));
        }
        return ((PCollection)inputPCollections.getPipeline().apply(stageName, (PTransform)Create.of(rows))).setCoder((Coder)beamSQLRowType.getRecordCoder());
    }
}

