/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSetOperatorsTransforms;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;

public class BeamSetOperatorRelBase {
    private BeamRelNode beamRelNode;
    private List<RelNode> inputs;
    private boolean all;
    private OpType opType;

    public BeamSetOperatorRelBase(BeamRelNode beamRelNode, OpType opType, List<RelNode> inputs, boolean all) {
        this.beamRelNode = beamRelNode;
        this.opType = opType;
        this.inputs = inputs;
        this.all = all;
    }

    public PCollection<BeamRecord> buildBeamPipeline(PCollectionTuple inputPCollections, BeamSqlEnv sqlEnv) throws Exception {
        WindowFn rightWindow;
        PCollection<BeamRecord> leftRows = BeamSqlRelUtils.getBeamRelInput(this.inputs.get(0)).buildBeamPipeline(inputPCollections, sqlEnv);
        PCollection<BeamRecord> rightRows = BeamSqlRelUtils.getBeamRelInput(this.inputs.get(1)).buildBeamPipeline(inputPCollections, sqlEnv);
        WindowFn leftWindow = leftRows.getWindowingStrategy().getWindowFn();
        if (!leftWindow.isCompatible(rightWindow = rightRows.getWindowingStrategy().getWindowFn())) {
            throw new IllegalArgumentException("inputs of " + this.opType + " have different window strategy: " + leftWindow + " VS " + rightWindow);
        }
        TupleTag leftTag = new TupleTag();
        TupleTag rightTag = new TupleTag();
        String stageName = BeamSqlRelUtils.getStageName(this.beamRelNode);
        PCollection coGbkResultCollection = (PCollection)KeyedPCollectionTuple.of((TupleTag)leftTag, (PCollection)((PCollection)leftRows.apply(stageName + "_CreateLeftIndex", (PTransform)MapElements.via((SimpleFunction)new BeamSetOperatorsTransforms.BeamSqlRow2KvFn())))).and(rightTag, (PCollection)rightRows.apply(stageName + "_CreateRightIndex", (PTransform)MapElements.via((SimpleFunction)new BeamSetOperatorsTransforms.BeamSqlRow2KvFn()))).apply((PTransform)CoGroupByKey.create());
        PCollection ret = (PCollection)coGbkResultCollection.apply((PTransform)ParDo.of((DoFn)new BeamSetOperatorsTransforms.SetOperatorFilteringDoFn((TupleTag<BeamRecord>)leftTag, (TupleTag<BeamRecord>)rightTag, this.opType, this.all)));
        return ret;
    }

    public static enum OpType implements Serializable
    {
        UNION,
        INTERSECT,
        MINUS;

    }
}

