/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelDataTypeSystem;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.config.Lex;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Contexts;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Frameworks;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Planner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.ValidationException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamQueryPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(BeamQueryPlanner.class);
    protected final Planner planner;
    private Map<String, BeamSqlTable> sourceTables = new HashMap<String, BeamSqlTable>();
    public static final JavaTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);

    public BeamQueryPlanner(SchemaPlus schema) {
        String defaultCharsetKey = "saffron.default.charset";
        if (System.getProperty(defaultCharsetKey) == null) {
            System.setProperty(defaultCharsetKey, ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
            System.setProperty("saffron.default.nationalcharset", ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
            System.setProperty("saffron.default.collation.name", String.format("%s$%s", ConversionUtil.NATIVE_UTF16_CHARSET_NAME, "en_US"));
        }
        ArrayList<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(RelCollationTraitDef.INSTANCE);
        ArrayList<SqlOperatorTable> sqlOperatorTables = new ArrayList<SqlOperatorTable>();
        sqlOperatorTables.add(SqlStdOperatorTable.instance());
        sqlOperatorTables.add(new CalciteCatalogReader(CalciteSchema.from(schema), false, Collections.emptyList(), (RelDataTypeFactory)TYPE_FACTORY));
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.MYSQL).build()).defaultSchema(schema).traitDefs(traitDefs).context(Contexts.EMPTY_CONTEXT).ruleSets(BeamRuleSets.getRuleSets()).costFactory(null).typeSystem(BeamRelDataTypeSystem.BEAM_REL_DATATYPE_SYSTEM).operatorTable(new ChainedSqlOperatorTable(sqlOperatorTables)).build();
        this.planner = Frameworks.getPlanner(config);
        for (String t : schema.getTableNames()) {
            this.sourceTables.put(t, (BaseBeamTable)((Object)schema.getTable(t)));
        }
    }

    public SqlNode parseQuery(String sqlQuery) throws SqlParseException {
        return this.planner.parse(sqlQuery);
    }

    public PCollection<BeamRecord> compileBeamPipeline(String sqlStatement, Pipeline basePipeline, BeamSqlEnv sqlEnv) throws Exception {
        BeamRelNode relNode = this.convertToBeamRel(sqlStatement);
        return relNode.buildBeamPipeline(PCollectionTuple.empty((Pipeline)basePipeline), sqlEnv);
    }

    public BeamRelNode convertToBeamRel(String sqlStatement) throws ValidationException, RelConversionException, SqlParseException {
        BeamRelNode beamRelNode;
        try {
            beamRelNode = (BeamRelNode)this.validateAndConvert(this.planner.parse(sqlStatement));
        }
        finally {
            this.planner.close();
        }
        return beamRelNode;
    }

    private RelNode validateAndConvert(SqlNode sqlNode) throws ValidationException, RelConversionException {
        SqlNode validated = this.validateNode(sqlNode);
        LOG.info("SQL:\n" + validated);
        RelNode relNode = this.convertToRelNode(validated);
        return this.convertToBeamRel(relNode);
    }

    private RelNode convertToBeamRel(RelNode relNode) throws RelConversionException {
        RelTraitSet traitSet = relNode.getTraitSet();
        LOG.info("SQLPlan>\n" + RelOptUtil.toString(relNode));
        return this.planner.transform(0, traitSet.plus(BeamLogicalConvention.INSTANCE), relNode);
    }

    private RelNode convertToRelNode(SqlNode sqlNode) throws RelConversionException {
        return this.planner.rel((SqlNode)sqlNode).rel;
    }

    private SqlNode validateNode(SqlNode sqlNode) throws ValidationException {
        return this.planner.validate(sqlNode);
    }

    public Map<String, BeamSqlTable> getSourceTables() {
        return this.sourceTables;
    }

    public Planner getPlanner() {
        return this.planner;
    }
}

