/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.DatetimeReinterpretConversions;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.IntegerReinterpretConversions;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.reinterpret.Reinterpreter;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

public class BeamSqlReinterpretExpression
extends BeamSqlExpression {
    private static final Reinterpreter REINTERPRETER = Reinterpreter.builder().withConversion(DatetimeReinterpretConversions.TIME_TO_BIGINT).withConversion(DatetimeReinterpretConversions.DATE_TYPES_TO_BIGINT).withConversion(IntegerReinterpretConversions.INTEGER_TYPES_TO_BIGINT).build();

    public BeamSqlReinterpretExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    @Override
    public boolean accept() {
        return this.getOperands().size() == 1 && REINTERPRETER.canConvert(this.opType(0), SqlTypeName.BIGINT);
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRow, BoundedWindow window) {
        return REINTERPRETER.convert(SqlTypeName.BIGINT, ((BeamSqlExpression)this.operands.get(0)).evaluate(inputRow, window));
    }
}

