/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlTimestampMinusIntervalExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlTimestampMinusTimestampExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.DurationFieldType;

public class BeamSqlDatetimeMinusExpression
extends BeamSqlExpression {
    static final Map<SqlTypeName, DurationFieldType> INTERVALS_DURATIONS_TYPES = ImmutableMap.builder().put(SqlTypeName.INTERVAL_SECOND, DurationFieldType.seconds()).put(SqlTypeName.INTERVAL_MINUTE, DurationFieldType.minutes()).put(SqlTypeName.INTERVAL_HOUR, DurationFieldType.hours()).put(SqlTypeName.INTERVAL_DAY, DurationFieldType.days()).put(SqlTypeName.INTERVAL_MONTH, DurationFieldType.months()).put(SqlTypeName.INTERVAL_YEAR, DurationFieldType.years()).build();
    private BeamSqlExpression delegateExpression;

    public BeamSqlDatetimeMinusExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
        this.delegateExpression = this.createDelegateExpression(operands, outputType);
    }

    private BeamSqlExpression createDelegateExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        if (this.isTimestampMinusTimestamp(operands, outputType)) {
            return new BeamSqlTimestampMinusTimestampExpression(operands, outputType);
        }
        if (this.isTimestampMinusInterval(operands, outputType)) {
            return new BeamSqlTimestampMinusIntervalExpression(operands, outputType);
        }
        return null;
    }

    private boolean isTimestampMinusTimestamp(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        return BeamSqlTimestampMinusTimestampExpression.accept(operands, outputType);
    }

    private boolean isTimestampMinusInterval(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        return BeamSqlTimestampMinusIntervalExpression.accept(operands, outputType);
    }

    @Override
    public boolean accept() {
        return this.delegateExpression != null && this.delegateExpression.accept();
    }

    @Override
    public BeamSqlPrimitive evaluate(BeamRecord inputRow, BoundedWindow window) {
        if (this.delegateExpression == null) {
            throw new IllegalStateException("Unable to execute unsupported 'datetime minus' expression");
        }
        return this.delegateExpression.evaluate(inputRow, window);
    }
}

