/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.DataContext;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.ScannableTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Schema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Statistic;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Statistics;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.Frameworks;

public class BeamSqlEnv
implements Serializable {
    transient SchemaPlus schema = Frameworks.createRootSchema(true);
    transient BeamQueryPlanner planner = new BeamQueryPlanner(this.schema);

    public void registerUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
        this.schema.add(functionName, ScalarFunctionImpl.create(clazz, "eval"));
    }

    public void registerUdf(String functionName, SerializableFunction sfn) {
        this.schema.add(functionName, ScalarFunctionImpl.create(sfn.getClass(), "apply"));
    }

    public void registerUdaf(String functionName, Combine.CombineFn combineFn) {
        this.schema.add(functionName, new UdafImpl(combineFn));
    }

    public void registerTable(String tableName, BeamSqlTable table) {
        this.schema.add(tableName, new BeamCalciteTable(table.getRowType()));
        this.planner.getSourceTables().put(tableName, table);
    }

    public BeamSqlTable findTable(String tableName) {
        return this.planner.getSourceTables().get(tableName);
    }

    public BeamQueryPlanner getPlanner() {
        return this.planner;
    }

    private static class BeamCalciteTable
    implements ScannableTable,
    Serializable {
        private BeamRecordSqlType beamSqlRowType;

        public BeamCalciteTable(BeamRecordSqlType beamSqlRowType) {
            this.beamSqlRowType = beamSqlRowType;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return (RelDataType)CalciteUtils.toCalciteRowType(this.beamSqlRowType).apply(BeamQueryPlanner.TYPE_FACTORY);
        }

        @Override
        public Enumerable<Object[]> scan(DataContext root) {
            return null;
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }
    }
}

