/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.example;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.BeamSql;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.BeamRecordType;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;

class BeamSqlExample {
    BeamSqlExample() {
    }

    public static void main(String[] args) throws Exception {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).as(PipelineOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        List<String> fieldNames = Arrays.asList("c1", "c2", "c3");
        List<Integer> fieldTypes = Arrays.asList(4, 12, 8);
        BeamRecordSqlType type = BeamRecordSqlType.create(fieldNames, fieldTypes);
        BeamRecord row1 = new BeamRecord((BeamRecordType)type, new Object[]{1, "row", 1.0});
        BeamRecord row2 = new BeamRecord((BeamRecordType)type, new Object[]{2, "row", 2.0});
        BeamRecord row3 = new BeamRecord((BeamRecordType)type, new Object[]{3, "row", 3.0});
        PCollection inputTable = (PCollection)PBegin.in((Pipeline)p).apply((PTransform)Create.of((Object)row1, (Object[])new BeamRecord[]{row2, row3}).withCoder((Coder)type.getRecordCoder()));
        PCollection outputStream = (PCollection)inputTable.apply((PTransform)BeamSql.query("select c1, c2, c3 from PCOLLECTION where c1 > 1"));
        outputStream.apply("log_result", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<BeamRecord, Void>(){

            @Nullable
            public Void apply(BeamRecord input) {
                System.out.println("PCOLLECTION: " + input.getDataValues());
                return null;
            }
        }));
        PCollection outputStream2 = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("CASE1_RESULT"), (PCollection)outputStream).apply((PTransform)BeamSql.queryMulti("select c2, sum(c3) from CASE1_RESULT group by c2"));
        outputStream2.apply("log_result", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<BeamRecord, Void>(){

            @Nullable
            public Void apply(BeamRecord input) {
                System.out.println("CASE1_RESULT: " + input.getDataValues());
                return null;
            }
        }));
        p.run().waitUntilFinish();
    }
}

