/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.ParserUtils;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlCreateTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;

@Experimental
public class BeamSqlCli {
    private BeamSqlEnv env;
    private MetaStore metaStore;

    public BeamSqlCli metaStore(MetaStore metaStore) {
        this.metaStore = metaStore;
        this.env = new BeamSqlEnv();
        List<Table> tables = this.metaStore.listTables();
        for (Table table : tables) {
            this.env.registerTable(table.getName(), metaStore.buildBeamSqlTable(table.getName()));
        }
        return this;
    }

    public MetaStore getMetaStore() {
        return this.metaStore;
    }

    public String explainQuery(String sqlString) throws Exception {
        BeamRelNode exeTree = this.env.getPlanner().convertToBeamRel(sqlString);
        String beamPlan = RelOptUtil.toString(exeTree);
        return beamPlan;
    }

    public void execute(String sqlString) throws Exception {
        BeamSqlParser parser = new BeamSqlParser(sqlString);
        SqlNode sqlNode = parser.impl().parseSqlStmtEof();
        if (sqlNode instanceof SqlCreateTable) {
            this.handleCreateTable((SqlCreateTable)sqlNode, this.metaStore);
        } else {
            PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[0]).withValidation().as(PipelineOptions.class);
            options.setJobName("BeamPlanCreator");
            Pipeline pipeline = Pipeline.create((PipelineOptions)options);
            BeamSqlCli.compilePipeline(sqlString, pipeline, this.env);
            pipeline.run();
        }
    }

    private void handleCreateTable(SqlCreateTable stmt, MetaStore store) {
        Table table = ParserUtils.convertCreateTableStmtToTable(stmt);
        if (table.getType() == null) {
            throw new IllegalStateException("Table type is not specified and BeamSqlCli#defaultTableTypeis not configured!");
        }
        store.createTable(table);
        this.env.registerTable(table.getName(), this.metaStore.buildBeamSqlTable(table.getName()));
    }

    private static PCollection<BeamRecord> compilePipeline(String sqlStatement, Pipeline basePipeline, BeamSqlEnv sqlEnv) throws Exception {
        PCollection<BeamRecord> resultStream = sqlEnv.getPlanner().compileBeamPipeline(sqlStatement, basePipeline, sqlEnv);
        return resultStream;
    }
}

