/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.BeamRecordCoder;
import org.apache.beam.sdk.extensions.sql.BeamRecordSqlType;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamPCollectionTable;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.ValidationException;

@Experimental
public class BeamSql {
    public static QueryTransform queryMulti(String sqlQuery) {
        return new QueryTransform(sqlQuery);
    }

    public static SimpleQueryTransform query(String sqlQuery) {
        return new SimpleQueryTransform(sqlQuery);
    }

    public static class SimpleQueryTransform
    extends PTransform<PCollection<BeamRecord>, PCollection<BeamRecord>> {
        private static final String PCOLLECTION_TABLE_NAME = "PCOLLECTION";
        private QueryTransform delegate;

        public SimpleQueryTransform(String sqlQuery) {
            this.delegate = new QueryTransform(sqlQuery);
        }

        public SimpleQueryTransform withUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
            this.delegate.withUdf(functionName, clazz);
            return this;
        }

        public SimpleQueryTransform withUdf(String functionName, SerializableFunction sfn) {
            this.delegate.withUdf(functionName, sfn);
            return this;
        }

        public SimpleQueryTransform withUdaf(String functionName, Combine.CombineFn combineFn) {
            this.delegate.withUdaf(functionName, combineFn);
            return this;
        }

        private void validateQuery() {
            SqlNode sqlNode;
            try {
                sqlNode = this.delegate.beamSqlEnv.getPlanner().parseQuery(this.delegate.sqlQuery);
                this.delegate.beamSqlEnv.getPlanner().getPlanner().close();
            }
            catch (SqlParseException e) {
                throw new IllegalStateException(e);
            }
            if (sqlNode instanceof SqlSelect) {
                SqlSelect select = (SqlSelect)sqlNode;
                String tableName = select.getFrom().toString();
                if (!tableName.equalsIgnoreCase(PCOLLECTION_TABLE_NAME)) {
                    throw new IllegalStateException("Use fixed table name PCOLLECTION");
                }
            } else {
                throw new UnsupportedOperationException("Sql operation: " + sqlNode.toString() + " is not supported!");
            }
        }

        public PCollection<BeamRecord> expand(PCollection<BeamRecord> input) {
            this.validateQuery();
            return (PCollection)PCollectionTuple.of((TupleTag)new TupleTag(PCOLLECTION_TABLE_NAME), input).apply((PTransform)this.delegate);
        }
    }

    public static class QueryTransform
    extends PTransform<PCollectionTuple, PCollection<BeamRecord>> {
        private BeamSqlEnv beamSqlEnv = new BeamSqlEnv();
        private String sqlQuery;

        public QueryTransform(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        public QueryTransform withUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
            this.beamSqlEnv.registerUdf(functionName, clazz);
            return this;
        }

        public QueryTransform withUdf(String functionName, SerializableFunction sfn) {
            this.beamSqlEnv.registerUdf(functionName, sfn);
            return this;
        }

        public QueryTransform withUdaf(String functionName, Combine.CombineFn combineFn) {
            this.beamSqlEnv.registerUdaf(functionName, combineFn);
            return this;
        }

        public PCollection<BeamRecord> expand(PCollectionTuple input) {
            this.registerTables(input);
            BeamRelNode beamRelNode = null;
            try {
                beamRelNode = this.beamSqlEnv.getPlanner().convertToBeamRel(this.sqlQuery);
            }
            catch (SqlParseException | RelConversionException | ValidationException e) {
                throw new IllegalStateException(e);
            }
            try {
                return beamRelNode.buildBeamPipeline(input, this.beamSqlEnv);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private void registerTables(PCollectionTuple input) {
            for (TupleTag sourceTag : input.getAll().keySet()) {
                PCollection sourceStream = input.get(sourceTag);
                BeamRecordCoder sourceCoder = (BeamRecordCoder)sourceStream.getCoder();
                this.beamSqlEnv.registerTable(sourceTag.getId(), new BeamPCollectionTable((PCollection<BeamRecord>)sourceStream, (BeamRecordSqlType)sourceCoder.getRecordType()));
            }
        }
    }
}

