/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.NestedPayloadKafkaTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.PayloadSerializerKafkaTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.Schemas;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializers;
import org.apache.beam.sdk.util.Preconditions;

public class KafkaTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        PayloadSerializer serializer;
        Optional<String> payloadFormat;
        Schema schema = table.getSchema();
        JSONObject properties = table.getProperties();
        String bootstrapServers = properties.getString("bootstrap.servers");
        JSONArray topicsArr = properties.getJSONArray("topics");
        ArrayList<String> topics = new ArrayList<String>(topicsArr.size());
        for (Object topic : topicsArr) {
            topics.add(topic.toString());
        }
        Optional<String> optional = payloadFormat = properties.containsKey((Object)"format") ? Optional.of(properties.getString("format")) : Optional.empty();
        if (Schemas.isNestedSchema(schema)) {
            serializer = payloadFormat.map(format -> PayloadSerializers.getSerializer((String)format, (Schema)((Schema)Preconditions.checkArgumentNotNull((Object)schema.getField("payload").getType().getRowSchema())), (Map)properties.getInnerMap()));
            return new NestedPayloadKafkaTable(schema, bootstrapServers, (List<String>)topics, (Optional<PayloadSerializer>)serializer);
        }
        if (payloadFormat.orElse("csv").equals("csv")) {
            return new BeamKafkaCSVTable(schema, bootstrapServers, topics);
        }
        serializer = PayloadSerializers.getSerializer((String)((String)payloadFormat.get()), (Schema)schema, (Map)properties.getInnerMap());
        return new PayloadSerializerKafkaTable(schema, bootstrapServers, topics, serializer);
    }

    @Override
    public String getTableType() {
        return "kafka";
    }
}

