/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.AutoValue_VarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;

@AutoValue
abstract class VarianceAccumulator
implements Serializable {
    static final VarianceAccumulator EMPTY = VarianceAccumulator.newVarianceAccumulator(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);

    VarianceAccumulator() {
    }

    abstract BigDecimal variance();

    abstract BigDecimal count();

    abstract BigDecimal sum();

    static VarianceAccumulator newVarianceAccumulator(BigDecimal variance, BigDecimal count, BigDecimal sum) {
        return new AutoValue_VarianceAccumulator(variance, count, sum);
    }

    static VarianceAccumulator ofZeroElements() {
        return EMPTY;
    }

    static VarianceAccumulator ofSingleElement(BigDecimal inputElement) {
        return VarianceAccumulator.newVarianceAccumulator(BigDecimal.ZERO, BigDecimal.ONE, inputElement);
    }

    VarianceAccumulator combineWith(VarianceAccumulator otherVariance) {
        if (EMPTY.equals(this)) {
            return otherVariance;
        }
        if (EMPTY.equals(otherVariance)) {
            return this;
        }
        BigDecimal increment = this.calculateIncrement(this, otherVariance);
        BigDecimal combinedVariance = this.variance().add(otherVariance.variance()).add(increment);
        return VarianceAccumulator.newVarianceAccumulator(combinedVariance, this.count().add(otherVariance.count()), this.sum().add(otherVariance.sum()));
    }

    private BigDecimal calculateIncrement(VarianceAccumulator varianceX, VarianceAccumulator varianceY) {
        BigDecimal m = varianceX.count();
        BigDecimal n = varianceY.count();
        BigDecimal sumX = varianceX.sum();
        BigDecimal sumY = varianceY.sum();
        BigDecimal multiplier = m.divide(n.multiply(m.add(n)), VarianceFn.MATH_CTX);
        BigDecimal square = sumX.multiply(n).divide(m, VarianceFn.MATH_CTX).subtract(sumY).pow(2);
        return multiplier.multiply(square);
    }
}

