/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import org.apache.beam.sdk.transforms.Combine;

public class CountIf {
    private CountIf() {
    }

    public static CountIfFn combineFn() {
        return new CountIfFn();
    }

    public static class CountIfFn
    extends Combine.CombineFn<Boolean, Accum, Long> {
        public Accum createAccumulator() {
            return new Accum();
        }

        public Accum addInput(Accum accum, Boolean input) {
            if (input.booleanValue()) {
                accum.isExpressionFalse = false;
                ++accum.countIfResult;
            }
            return accum;
        }

        public Accum mergeAccumulators(Iterable<Accum> accums) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accums) {
                if (accum.isExpressionFalse) continue;
                merged.countIfResult += accum.countIfResult;
            }
            return merged;
        }

        public Long extractOutput(Accum accum) {
            if (!accum.isExpressionFalse) {
                return accum.countIfResult;
            }
            return 0L;
        }

        public static class Accum {
            boolean isExpressionFalse = true;
            long countIfResult = 0L;
        }
    }
}

