/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.SingleRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Filter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Project;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RelBuilderFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamAggregateProjectMergeRule
extends AggregateProjectMergeRule {
    public static final @UnknownKeyFor @NonNull @Initialized AggregateProjectMergeRule INSTANCE = new BeamAggregateProjectMergeRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public BeamAggregateProjectMergeRule(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Aggregate> aggregateClass, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Project> projectClass, @UnknownKeyFor @NonNull @Initialized RelBuilderFactory relBuilderFactory) {
        super(aggregateClass, projectClass, relBuilderFactory);
    }

    public void onMatch(@UnknownKeyFor @NonNull @Initialized RelOptRuleCall call) {
        Project project = (Project)call.rel(1);
        BeamIOSourceRel io = this.getUnderlyingIO(new HashSet<RelNode>(), (SingleRel)project);
        if (io == null || !io.getBeamSqlTable().supportsProjects().isSupported()) {
            super.onMatch(call);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized BeamIOSourceRel getUnderlyingIO(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RelNode> visitedNodes, @UnknownKeyFor @NonNull @Initialized SingleRel parent) {
        if (visitedNodes.contains(parent)) {
            return null;
        }
        visitedNodes.add((RelNode)parent);
        List nodes = ((RelSubset)parent.getInput()).getRelList();
        for (RelNode node : nodes) {
            if (node instanceof Filter || node instanceof Project) {
                BeamIOSourceRel child = this.getUnderlyingIO(visitedNodes, (SingleRel)node);
                if (child == null) continue;
                return child;
            }
            if (!(node instanceof BeamIOSourceRel)) continue;
            return (BeamIOSourceRel)node;
        }
        return null;
    }
}

