/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.Linq4j;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamEnumerableConverter.class);

    public BeamEnumerableConverter(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public @UnknownKeyFor @NonNull @Initialized RelNode copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        return new BeamEnumerableConverter(this.getCluster(), traitSet, (RelNode)BeamEnumerableConverter.sole(inputs));
    }

    public @UnknownKeyFor @NonNull @Initialized RelOptCost computeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        return planner.getCostFactory().makeHugeCost();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized EnumerableRel.Result implement(@UnknownKeyFor @NonNull @Initialized EnumerableRelImplementor implementor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized EnumerableRel.Prefer prefer) {
        BlockBuilder list = new BlockBuilder();
        RelDataType rowType = this.getRowType();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)prefer.preferArray());
        Expression node = implementor.stash((Object)((BeamRelNode)this.getInput()), BeamRelNode.class);
        list.add((Expression)Expressions.call(BeamEnumerableConverter.class, (String)"toEnumerable", (Expression[])new Expression[]{node}));
        return implementor.result(physType, list.toBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownKeyFor @NonNull @Initialized Enumerable<@UnknownKeyFor @NonNull @Initialized Object> toEnumerable(@UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BeamEnumerableConverter.class.getClassLoader());
            PipelineOptions options = BeamEnumerableConverter.createPipelineOptions(node.getPipelineOptions());
            Enumerable<Object> enumerable = BeamEnumerableConverter.toEnumerable(options, node);
            return enumerable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> toRowList(@UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        return BeamEnumerableConverter.toRowList(node, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> toRowList(@UnknownKeyFor @NonNull @Initialized BeamRelNode node, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> otherOptions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BeamEnumerableConverter.class.getClassLoader());
            HashMap<String, String> optionsMap = new HashMap<String, String>();
            optionsMap.putAll(node.getPipelineOptions());
            optionsMap.putAll(otherOptions);
            List<Row> list = BeamEnumerableConverter.toRowList(BeamEnumerableConverter.createPipelineOptions(optionsMap), node);
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineOptions createPipelineOptions(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> map) {
        String[] args = new String[map.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            args[i++] = "--" + entry.getKey() + "=" + entry.getValue();
        }
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).withValidation().create();
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        ((ApplicationNameOptions)options.as(ApplicationNameOptions.class)).setAppName("BeamSql");
        return options;
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> toRowList(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        if (node instanceof BeamIOSinkRel) {
            throw new UnsupportedOperationException("Does not support BeamIOSinkRel in toRowList.");
        }
        if (BeamEnumerableConverter.isLimitQuery(node)) {
            throw new UnsupportedOperationException("Does not support queries with LIMIT in toRowList.");
        }
        return BeamEnumerableConverter.collectRows(options, node).stream().collect(Collectors.toList());
    }

    static @UnknownKeyFor @NonNull @Initialized Enumerable<@UnknownKeyFor @NonNull @Initialized Object> toEnumerable(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        if (node instanceof BeamIOSinkRel) {
            return BeamEnumerableConverter.count(options, node);
        }
        if (BeamEnumerableConverter.isLimitQuery(node)) {
            return BeamEnumerableConverter.limitCollect(options, node);
        }
        return Linq4j.asEnumerable(BeamEnumerableConverter.rowToAvaticaAndUnboxValues(BeamEnumerableConverter.collectRows(options, node)));
    }

    /*
     * Exception decompiling
     */
    private static @UnknownKeyFor @NonNull @Initialized PipelineResult limitRun(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node, @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @Nullable @Initialized Void> doFn, @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Row> values, @UnknownKeyFor @NonNull @Initialized int limitCount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void runCollector(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection<Row> resultCollection = BeamSqlRelUtils.toPCollection(pipeline, node);
        resultCollection.apply((PTransform)ParDo.of((DoFn)new Collector()));
        PipelineResult result = pipeline.run();
        if (PipelineResult.State.FAILED.equals((Object)result.waitUntilFinish())) {
            throw new RuntimeException("Pipeline failed for unknown reason");
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Row> collectRows(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        long id = options.getOptionsId();
        ConcurrentLinkedQueue<Row> values = new ConcurrentLinkedQueue<Row>();
        Preconditions.checkArgument((boolean)options.getRunner().getCanonicalName().equals("org.apache.beam.runners.direct.DirectRunner"), (Object)"collectRowList is only available in direct runner.");
        Collector.globalValues.put(id, values);
        BeamEnumerableConverter.runCollector(options, node);
        Collector.globalValues.remove(id);
        return values;
    }

    private static @UnknownKeyFor @NonNull @Initialized Enumerable<@UnknownKeyFor @NonNull @Initialized Object> limitCollect(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        long id = options.getOptionsId();
        ConcurrentLinkedQueue<Row> values = new ConcurrentLinkedQueue<Row>();
        Preconditions.checkArgument((boolean)options.getRunner().getCanonicalName().equals("org.apache.beam.runners.direct.DirectRunner"), (Object)"SELECT without INSERT is only supported in DirectRunner in SQL Shell.");
        int limitCount = BeamEnumerableConverter.getLimitCount(node);
        Collector.globalValues.put(id, values);
        BeamEnumerableConverter.limitRun(options, node, new Collector(), values, limitCount);
        Collector.globalValues.remove(id);
        while (values.size() > limitCount) {
            values.remove();
        }
        return Linq4j.asEnumerable(BeamEnumerableConverter.rowToAvaticaAndUnboxValues(values));
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> rowToAvaticaAndUnboxValues(@UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Row> values) {
        return values.stream().map(row -> {
            Object[] objects = BeamEnumerableConverter.rowToAvatica(row);
            if (objects.length == 1) {
                return objects[0];
            }
            return objects;
        }).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] rowToAvatica(@UnknownKeyFor @NonNull @Initialized Row row) {
        Schema schema = row.getSchema();
        Object[] convertedColumns = new Object[schema.getFields().size()];
        int i = 0;
        for (Schema.Field field : schema.getFields()) {
            convertedColumns[i] = BeamEnumerableConverter.fieldToAvatica(field.getType(), row.getBaseValue(i, Object.class));
            ++i;
        }
        return convertedColumns;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object fieldToAvatica(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType type, @UnknownKeyFor @NonNull @Initialized Object beamValue) {
        if (beamValue == null) {
            return null;
        }
        switch (type.getTypeName()) {
            case LOGICAL_TYPE: {
                String logicalId = type.getLogicalType().getIdentifier();
                if (SqlTypes.TIME.getIdentifier().equals(logicalId)) {
                    if (beamValue instanceof Long) {
                        return (Long)beamValue;
                    }
                    return ((LocalTime)beamValue).toNanoOfDay();
                }
                if (SqlTypes.DATE.getIdentifier().equals(logicalId)) {
                    if (beamValue instanceof Long) {
                        return ((Long)beamValue).intValue();
                    }
                    return (int)((LocalDate)beamValue).toEpochDay();
                }
                if ("SqlCharType".equals(logicalId)) {
                    return beamValue;
                }
                throw new UnsupportedOperationException("Unknown DateTime type " + logicalId);
            }
            case DATETIME: {
                return ((ReadableInstant)beamValue).getMillis();
            }
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: 
            case BYTES: {
                return beamValue;
            }
            case ARRAY: {
                return ((List)beamValue).stream().map(elem -> BeamEnumerableConverter.fieldToAvatica(type.getCollectionElementType(), elem)).collect(Collectors.toList());
            }
            case ITERABLE: {
                return StreamSupport.stream(((Iterable)beamValue).spliterator(), false).map(elem -> BeamEnumerableConverter.fieldToAvatica(type.getCollectionElementType(), elem)).collect(Collectors.toList());
            }
            case MAP: {
                return ((Map)beamValue).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> BeamEnumerableConverter.fieldToAvatica(type.getCollectionElementType(), entry.getValue())));
            }
            case ROW: {
                return beamValue;
            }
        }
        throw new IllegalStateException(String.format("Unreachable case for Beam typename %s", type.getTypeName()));
    }

    private static @UnknownKeyFor @NonNull @Initialized Enumerable<@UnknownKeyFor @NonNull @Initialized Object> count(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        BeamSqlRelUtils.toPCollection(pipeline, node).apply((PTransform)ParDo.of((DoFn)new RowCounter()));
        PipelineResult result = pipeline.run();
        long count = 0L;
        if (!BeamEnumerableConverter.containsUnboundedPCollection(pipeline)) {
            if (PipelineResult.State.FAILED.equals((Object)result.waitUntilFinish())) {
                throw new RuntimeException("Pipeline failed for unknown reason");
            }
            MetricQueryResults metrics = result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named(BeamEnumerableConverter.class, (String)"rows")).build());
            Iterator iterator = metrics.getCounters().iterator();
            if (iterator.hasNext()) {
                count = (Long)((MetricResult)iterator.next()).getAttempted();
            }
        }
        return Linq4j.singletonEnumerable((Object)count);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isLimitQuery(@UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        return node instanceof BeamSortRel && ((BeamSortRel)node).isLimitOnly() || node instanceof AbstractBeamCalcRel && ((AbstractBeamCalcRel)node).isInputSortRelAndLimitOnly();
    }

    private static @UnknownKeyFor @NonNull @Initialized int getLimitCount(@UnknownKeyFor @NonNull @Initialized BeamRelNode node) {
        if (node instanceof BeamSortRel) {
            return ((BeamSortRel)node).getCount();
        }
        if (node instanceof AbstractBeamCalcRel) {
            return ((AbstractBeamCalcRel)node).getLimitCountOfSortRel();
        }
        throw new IllegalArgumentException("Cannot get limit count from RelNode tree with root " + node.getRelTypeName());
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean containsUnboundedPCollection(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        class BoundednessVisitor
        extends Pipeline.PipelineVisitor.Defaults {
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded boundedness = PCollection.IsBounded.BOUNDED;

            BoundednessVisitor() {
            }

            public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
                if (value instanceof PCollection) {
                    this.boundedness = this.boundedness.and(((PCollection)value).isBounded());
                }
            }
        }
        BoundednessVisitor visitor = new BoundednessVisitor();
        p.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        return visitor.boundedness == PCollection.IsBounded.UNBOUNDED;
    }

    private static class RowCounter
    extends DoFn<Row, Void> {
        final @UnknownKeyFor @NonNull @Initialized Counter rows = Metrics.counter(BeamEnumerableConverter.class, (String)"rows");

        private RowCounter() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            this.rows.inc();
        }
    }

    private static class Collector
    extends DoFn<Row, Void> {
        private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Row>> globalValues = new ConcurrentHashMap<Long, Queue<Row>>();
        private volatile @Nullable @UnknownKeyFor @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Row> values;

        private Collector() {
        }

        @DoFn.StartBundle
        public void startBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext context) {
            long id = context.getPipelineOptions().getOptionsId();
            this.values = globalValues.get(id);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            this.values.add((Row)context.element());
        }
    }
}

