/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSetOperatorRelBase;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Minus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.SetOp;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamMinusRel
extends Minus
implements BeamRelNode {
    public BeamMinusRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs, @UnknownKeyFor @NonNull @Initialized boolean all) {
        super(cluster, traits, inputs, all);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        NodeStats inputsEstimatesSummation = this.inputs.stream().map(input -> BeamSqlRelUtils.getNodeStats(input, mq)).reduce(NodeStats.create(0.0, 0.0, 0.0), NodeStats::plus);
        return BeamCostModel.FACTORY.makeCost(inputsEstimatesSummation.getRowCount(), inputsEstimatesSummation.getRate());
    }

    public @UnknownKeyFor @NonNull @Initialized SetOp copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs, @UnknownKeyFor @NonNull @Initialized boolean all) {
        return new BeamMinusRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new BeamSetOperatorRelBase(this, BeamSetOperatorRelBase.OpType.MINUS, this.all);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        NodeStats firstInputEstimates = BeamSqlRelUtils.getNodeStats((RelNode)this.inputs.get(0), mq);
        for (int i = 1; i < this.inputs.size(); ++i) {
            NodeStats inputEstimate = BeamSqlRelUtils.getNodeStats((RelNode)this.inputs.get(i), mq);
            firstInputEstimates = firstInputEstimates.minus(inputEstimate.multiply(0.5));
        }
        return firstInputEstimates;
    }
}

