/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.cep;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPKind;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperator;
import org.apache.beam.sdk.extensions.sql.impl.cep.Quantifier;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class CEPPattern
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Schema mySchema;
    private final @UnknownKeyFor @NonNull @Initialized String patternVar;
    private final @UnknownKeyFor @NonNull @Initialized CEPCall patternCondition;
    private final @UnknownKeyFor @NonNull @Initialized Quantifier quant;

    private CEPPattern(@UnknownKeyFor @NonNull @Initialized Schema mySchema, @UnknownKeyFor @NonNull @Initialized String patternVar, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RexCall patternDef, @UnknownKeyFor @NonNull @Initialized Quantifier quant) {
        this.mySchema = mySchema;
        this.patternVar = patternVar;
        this.quant = quant;
        if (patternDef == null) {
            this.patternCondition = null;
            return;
        }
        this.patternCondition = CEPCall.of(patternDef);
    }

    private @UnknownKeyFor @NonNull @Initialized int evalOperation(@UnknownKeyFor @NonNull @Initialized CEPCall operation, @UnknownKeyFor @NonNull @Initialized CEPLiteral lit, @UnknownKeyFor @NonNull @Initialized Row rowEle) {
        CEPOperator call = operation.getOperator();
        List<CEPOperation> operands = operation.getOperands();
        if (call.getCepKind() == CEPKind.LAST) {
            CEPOperation opr0 = operands.get(0);
            CEPLiteral opr1 = (CEPLiteral)operands.get(1);
            if (opr0.getClass() == CEPFieldRef.class && opr1.getDecimal().equals(BigDecimal.ZERO)) {
                int fIndex = ((CEPFieldRef)opr0).getIndex();
                Schema.Field fd = this.mySchema.getField(fIndex);
                Schema.FieldType dtype = fd.getType();
                switch (dtype.getTypeName()) {
                    case BYTE: {
                        return rowEle.getByte(fIndex).compareTo(lit.getByte());
                    }
                    case INT16: {
                        return rowEle.getInt16(fIndex).compareTo(lit.getInt16());
                    }
                    case INT32: {
                        return rowEle.getInt32(fIndex).compareTo(lit.getInt32());
                    }
                    case INT64: {
                        return rowEle.getInt64(fIndex).compareTo(lit.getInt64());
                    }
                    case DECIMAL: {
                        return rowEle.getDecimal(fIndex).compareTo(lit.getDecimal());
                    }
                    case FLOAT: {
                        return rowEle.getFloat(fIndex).compareTo(lit.getFloat());
                    }
                    case DOUBLE: {
                        return rowEle.getDouble(fIndex).compareTo(lit.getDouble());
                    }
                    case STRING: {
                        return rowEle.getString(fIndex).compareTo(lit.getString());
                    }
                    case DATETIME: {
                        return rowEle.getDateTime(fIndex).compareTo((Object)lit.getDateTime());
                    }
                    case BOOLEAN: {
                        return rowEle.getBoolean(fIndex).compareTo(lit.getBoolean());
                    }
                }
                throw new UnsupportedOperationException("Specified column not comparable: " + fd.getName());
            }
        }
        throw new UnsupportedOperationException("backward functions (PREV, NEXT) not supported for now");
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.patternVar + this.quant.toString();
    }

    public @UnknownKeyFor @NonNull @Initialized CEPCall getPatternCondition() {
        return this.patternCondition;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPatternVar() {
        return this.patternVar;
    }

    public @UnknownKeyFor @NonNull @Initialized Quantifier getQuantifier() {
        return this.quant;
    }

    public static @UnknownKeyFor @NonNull @Initialized CEPPattern of(@UnknownKeyFor @NonNull @Initialized Schema theSchema, @UnknownKeyFor @NonNull @Initialized String patternVar, @UnknownKeyFor @NonNull @Initialized RexCall patternDef, @UnknownKeyFor @NonNull @Initialized Quantifier quant) {
        return new CEPPattern(theSchema, patternVar, patternDef, quant);
    }
}

