/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableMap;

public class BigDecimalConverter {
    private static final Map<Schema.TypeName, SerializableFunction<BigDecimal, ? extends Number>> CONVERTER_MAP = ImmutableMap.builder().put((Object)Schema.TypeName.INT32, BigDecimal::intValue).put((Object)Schema.TypeName.INT16, Number::shortValue).put((Object)Schema.TypeName.BYTE, Number::byteValue).put((Object)Schema.TypeName.INT64, BigDecimal::longValue).put((Object)Schema.TypeName.FLOAT, BigDecimal::floatValue).put((Object)Schema.TypeName.DOUBLE, BigDecimal::doubleValue).put((Object)Schema.TypeName.DECIMAL, (SerializableFunction & Serializable)v -> v).build();

    public static SerializableFunction<BigDecimal, ? extends Number> forSqlType(Schema.TypeName typeName) {
        if (!CONVERTER_MAP.containsKey(typeName)) {
            throw new UnsupportedOperationException("Conversion from " + typeName + " to BigDecimal is not supported");
        }
        return CONVERTER_MAP.get(typeName);
    }
}

