/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.schema;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.stream.IntStream;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.NlsString;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.joda.time.DateTime;

public final class BeamTableUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iterable<Row> csvLines2BeamRows(CSVFormat csvFormat, String line, Schema schema) {
        if (!line.endsWith(csvFormat.getRecordSeparator())) {
            line = line + csvFormat.getRecordSeparator();
        }
        try (CSVParser parser = CSVParser.parse((String)line, (CSVFormat)csvFormat);){
            ArrayList<Row> rows = new ArrayList<Row>();
            for (CSVRecord rawRecord : parser.getRecords()) {
                if (rawRecord.size() != schema.getFieldCount()) {
                    throw new IllegalArgumentException(String.format("Expect %d fields, but actually %d", schema.getFieldCount(), rawRecord.size()));
                }
                rows.add((Row)IntStream.range(0, schema.getFieldCount()).mapToObj(idx -> BeamTableUtils.autoCastField(schema.getField(idx), rawRecord.get(idx))).collect(Row.toRow((Schema)schema)));
            }
            ArrayList<Row> arrayList = rows;
            return arrayList;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not parse CSV records from %s with format %s", line, csvFormat), e);
        }
    }

    public static String beamRow2CsvLine(Row row, CSVFormat csvFormat) {
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = csvFormat.print((Appendable)writer);){
            for (int i = 0; i < row.getFieldCount(); ++i) {
                printer.print((Object)row.getBaseValue(i, Object.class).toString());
            }
            printer.println();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("encodeRecord failed!", e);
        }
        return writer.toString();
    }

    public static Object autoCastField(Schema.Field field, Object rawObj) {
        if (rawObj == null) {
            if (!field.getType().getNullable().booleanValue()) {
                throw new IllegalArgumentException(String.format("Field %s not nullable", field.getName()));
            }
            return null;
        }
        Schema.FieldType type = field.getType();
        if (CalciteUtils.isStringType(type)) {
            if (rawObj instanceof NlsString) {
                return ((NlsString)rawObj).getValue();
            }
            return rawObj;
        }
        if (CalciteUtils.DATE.typesEqual(type) || CalciteUtils.NULLABLE_DATE.typesEqual(type)) {
            if (rawObj instanceof GregorianCalendar) {
                GregorianCalendar calendar = (GregorianCalendar)rawObj;
                return Instant.ofEpochMilli(calendar.getTimeInMillis()).atZone(calendar.getTimeZone().toZoneId()).toLocalDate();
            }
            return LocalDate.ofEpochDay(((Integer)rawObj).intValue());
        }
        if (CalciteUtils.isDateTimeType(type)) {
            return new DateTime(rawObj);
        }
        if (type.getTypeName().isNumericType() && (rawObj instanceof String || rawObj instanceof BigDecimal && type.getTypeName() != Schema.TypeName.DECIMAL)) {
            String raw = rawObj.toString();
            switch (type.getTypeName()) {
                case BYTE: {
                    return Byte.valueOf(raw);
                }
                case INT16: {
                    return Short.valueOf(raw);
                }
                case INT32: {
                    return Integer.valueOf(raw);
                }
                case INT64: {
                    return Long.valueOf(raw);
                }
                case FLOAT: {
                    return Float.valueOf(raw);
                }
                case DOUBLE: {
                    return Double.valueOf(raw);
                }
            }
            throw new UnsupportedOperationException(String.format("Column type %s is not supported yet!", type));
        }
        if (type.getTypeName().isPrimitiveType() && Schema.TypeName.BYTES.equals((Object)type.getTypeName()) && rawObj instanceof ByteString) {
            return ((ByteString)rawObj).getBytes();
        }
        return rawObj;
    }
}

