/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;

public class BeamUncollectRel
extends Uncollect
implements BeamRelNode {
    public BeamUncollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean withOrdinality) {
        super(cluster, traitSet, input, withOrdinality);
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        return new BeamUncollectRel(this.getCluster(), traitSet, input, this.withOrdinality);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq).multiply(2.0);
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats(this, mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    private static class UncollectDoFn
    extends DoFn<Row, Row> {
        private final Schema schema;

        private UncollectDoFn(Schema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element Row inputRow, DoFn.OutputReceiver<Row> output) {
            for (Object element : inputRow.getArray(0)) {
                if (element instanceof Row) {
                    Row nestedRow = (Row)element;
                    output.output((Object)Row.withSchema((Schema)this.schema).addValues(nestedRow.getValues()).build());
                    continue;
                }
                output.output((Object)Row.withSchema((Schema)this.schema).addValue(element).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object[])new Object[]{BeamUncollectRel.class.getSimpleName(), pinput});
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema(BeamUncollectRel.this.getRowType());
            PCollection uncollected = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new UncollectDoFn(outputSchema)))).setRowSchema(outputSchema);
            return uncollected;
        }
    }
}

