/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamJavaTypeFactory;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.DataContext;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.GotoExpressionKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Node;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Statement;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class BeamCalcRel
extends AbstractBeamCalcRel {
    private static final ParameterExpression outputSchemaParam = Expressions.parameter(Schema.class, (String)"outputSchema");
    private static final ParameterExpression processContextParam = Expressions.parameter(DoFn.ProcessContext.class, (String)"c");
    private static final Map<Schema.TypeName, Type> rawTypeMap = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte.class).put((Object)Schema.TypeName.INT16, Short.class).put((Object)Schema.TypeName.INT32, Integer.class).put((Object)Schema.TypeName.INT64, Long.class).put((Object)Schema.TypeName.FLOAT, Float.class).put((Object)Schema.TypeName.DOUBLE, Double.class).build();
    private static final DataContext CONTEXT_INSTANCE = new SlimDataContext();

    public BeamCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
    }

    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamCalcRel(this.getCluster(), traitSet, input, program);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static Expression castOutput(Expression value, Schema.FieldType toType) {
        Type rawType;
        if (value.getType() == Object.class || !(value.getType() instanceof Class)) {
            return value;
        }
        if (CalciteUtils.isDateTimeType(toType) && !Types.isAssignableFrom(ReadableInstant.class, (Type)((Class)value.getType()))) {
            return BeamCalcRel.castOutputTime(value, toType);
        }
        if (toType.getTypeName() == Schema.TypeName.DECIMAL && !Types.isAssignableFrom(BigDecimal.class, (Type)((Class)value.getType()))) {
            return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{value});
        }
        if (toType.getTypeName() == Schema.TypeName.BYTES && Types.isAssignableFrom(ByteString.class, (Type)((Class)value.getType()))) {
            return Expressions.condition((Expression)Expressions.equal((Expression)value, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.call((Expression)value, (String)"getBytes", (Expression[])new Expression[0]));
        }
        if ((((Class)value.getType()).isPrimitive() || Types.isAssignableFrom(Number.class, (Type)((Class)value.getType()))) && (rawType = rawTypeMap.get(toType.getTypeName())) != null) {
            return Types.castIfNecessary((Type)rawType, (Expression)value);
        }
        return value;
    }

    private static Expression castOutputTime(Expression value, Schema.FieldType toType) {
        Expression valueDateTime = value;
        if (CalciteUtils.TIMESTAMP.typesEqual(toType) || CalciteUtils.NULLABLE_TIMESTAMP.typesEqual(toType)) {
            if (value.getType() == Timestamp.class) {
                valueDateTime = Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG.method, (Expression[])new Expression[]{valueDateTime});
            }
        } else if (CalciteUtils.TIME.typesEqual(toType) || CalciteUtils.NULLABLE_TIME.typesEqual(toType)) {
            if (value.getType() == Time.class) {
                valueDateTime = Expressions.call((Method)BuiltInMethod.TIME_TO_INT.method, (Expression[])new Expression[]{valueDateTime});
            }
        } else if (CalciteUtils.DATE.typesEqual(toType) || CalciteUtils.NULLABLE_DATE.typesEqual(toType)) {
            if (value.getType() == Date.class) {
                valueDateTime = Expressions.call((Method)BuiltInMethod.DATE_TO_INT.method, (Expression[])new Expression[]{valueDateTime});
            }
            valueDateTime = Expressions.multiply((Expression)valueDateTime, (Expression)Expressions.constant((Object)86400000L));
        } else {
            throw new UnsupportedOperationException("Unknown DateTime type " + toType);
        }
        valueDateTime = Expressions.new_(DateTime.class, (Expression[])new Expression[]{valueDateTime, Expressions.parameter(DateTimeZone.class, (String)"org.joda.time.DateTimeZone.UTC")});
        if (!((Class)value.getType()).isPrimitive()) {
            valueDateTime = Expressions.condition((Expression)Expressions.equal((Expression)value, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)valueDateTime);
        }
        return valueDateTime;
    }

    private static Expression nullOr(Expression field, Expression ifNotNull) {
        return Expressions.condition((Expression)Expressions.equal((Expression)field, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.box((Expression)ifNotNull));
    }

    public static abstract class WrappedList<T>
    extends AbstractList<T> {
        private final List<Object> values;

        protected WrappedList(List<Object> values) {
            this.values = values;
        }

        @Override
        public T get(int index) {
            return this.value(this.values.get(index));
        }

        protected abstract T value(Object var1);

        @Override
        public int size() {
            return this.values.size();
        }
    }

    public static abstract class WrappedMap<V>
    extends AbstractMap<Object, V> {
        private final Map<Object, Object> map;

        protected WrappedMap(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public Set<Map.Entry<Object, V>> entrySet() {
            return Maps.transformValues(this.map, val -> val == null ? null : this.value(val)).entrySet();
        }

        @Override
        public V get(Object key) {
            return this.value(this.map.get(key));
        }

        protected abstract V value(Object var1);
    }

    public static abstract class WrappedRow
    extends AbstractList<Object> {
        private final Row row;

        protected WrappedRow(Row row) {
            this.row = row;
        }

        @Override
        public Object get(int index) {
            return this.field(this.row, index);
        }

        protected abstract Object field(Row var1, int var2);

        @Override
        public int size() {
            return this.row.getFieldCount();
        }
    }

    private static class SlimDataContext
    implements DataContext {
        private SlimDataContext() {
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            if (name.equals(DataContext.Variable.UTC_TIMESTAMP.camelName) || name.equals(DataContext.Variable.CURRENT_TIMESTAMP.camelName) || name.equals(DataContext.Variable.LOCAL_TIMESTAMP.camelName)) {
                return System.currentTimeMillis();
            }
            return null;
        }
    }

    private static class InputGetterImpl
    implements RexToLixTranslator.InputGetter {
        private static final Map<Schema.TypeName, String> TYPE_GETTER_MAP = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)"getByte").put((Object)Schema.TypeName.BYTES, (Object)"getBytes").put((Object)Schema.TypeName.INT16, (Object)"getInt16").put((Object)Schema.TypeName.INT32, (Object)"getInt32").put((Object)Schema.TypeName.INT64, (Object)"getInt64").put((Object)Schema.TypeName.DECIMAL, (Object)"getDecimal").put((Object)Schema.TypeName.FLOAT, (Object)"getFloat").put((Object)Schema.TypeName.DOUBLE, (Object)"getDouble").put((Object)Schema.TypeName.STRING, (Object)"getString").put((Object)Schema.TypeName.DATETIME, (Object)"getDateTime").put((Object)Schema.TypeName.BOOLEAN, (Object)"getBoolean").put((Object)Schema.TypeName.MAP, (Object)"getMap").put((Object)Schema.TypeName.ARRAY, (Object)"getArray").put((Object)Schema.TypeName.ITERABLE, (Object)"getIterable").put((Object)Schema.TypeName.ROW, (Object)"getRow").build();
        private static final Map<String, String> LOGICAL_TYPE_GETTER_MAP = ImmutableMap.builder().put((Object)"SqlDateType", (Object)"getDateTime").put((Object)"SqlTimeType", (Object)"getDateTime").put((Object)"SqlTimeWithLocalTzType", (Object)"getDateTime").put((Object)"SqlTimestampWithLocalTzType", (Object)"getDateTime").put((Object)"SqlCharType", (Object)"getString").build();
        private final Expression input;
        private final Schema inputSchema;

        private InputGetterImpl(Expression input, Schema inputSchema) {
            this.input = input;
            this.inputSchema = inputSchema;
        }

        public Expression field(BlockBuilder list, int index, Type storageType) {
            return InputGetterImpl.value(list, index, storageType, this.input, this.inputSchema);
        }

        private static Expression value(BlockBuilder list, int index, Type storageType, Expression input, Schema schema) {
            if (index >= schema.getFieldCount() || index < 0) {
                throw new IllegalArgumentException("Unable to find value #" + index);
            }
            Expression expression = list.append(list.newName("current"), input);
            if (storageType == Object.class) {
                return Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getValue", (Expression[])new Expression[]{Expressions.constant((Object)index)}), Object.class);
            }
            Schema.FieldType fromType = schema.getField(index).getType();
            String getter = fromType.getTypeName().isLogicalType() ? LOGICAL_TYPE_GETTER_MAP.get(fromType.getLogicalType().getIdentifier()) : TYPE_GETTER_MAP.get(fromType.getTypeName());
            if (getter == null) {
                throw new UnsupportedOperationException("Unable to get " + fromType.getTypeName());
            }
            MethodCallExpression value = Expressions.call((Expression)expression, (String)getter, (Expression[])new Expression[]{Expressions.constant((Object)index)});
            return InputGetterImpl.value((Expression)value, fromType);
        }

        private static Expression value(Expression value, Schema.FieldType type) {
            if (type.getTypeName().isLogicalType()) {
                MethodCallExpression millisField = Expressions.call((Expression)value, (String)"getMillis", (Expression[])new Expression[0]);
                String logicalId = type.getLogicalType().getIdentifier();
                if (logicalId.equals("SqlTimeType")) {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.convert_((Expression)millisField, Integer.TYPE));
                }
                if (logicalId.equals("SqlDateType")) {
                    value = BeamCalcRel.nullOr(value, (Expression)Expressions.convert_((Expression)Expressions.divide((Expression)millisField, (Expression)Expressions.constant((Object)86400000L)), Integer.TYPE));
                } else if (!logicalId.equals("SqlCharType")) {
                    throw new UnsupportedOperationException("Unknown LogicalType " + type.getLogicalType().getIdentifier());
                }
            } else {
                if (type.getTypeName().isMapType()) {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.map(value, type.getMapValueType()));
                }
                if (CalciteUtils.isDateTimeType(type)) {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)value, (String)"getMillis", (Expression[])new Expression[0]));
                }
                if (type.getTypeName().isCompositeType()) {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.row(value, type.getRowSchema()));
                }
                if (type.getTypeName().isCollectionType()) {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.list(value, type.getCollectionElementType()));
                }
                if (type.getTypeName() == Schema.TypeName.BYTES) {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.new_(ByteString.class, (Expression[])new Expression[]{Types.castIfNecessary(byte[].class, (Expression)value)}));
                }
            }
            return value;
        }

        private static Expression list(Expression input, Schema.FieldType elementType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.value((Expression)value, elementType));
            return Expressions.new_(WrappedList.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(List.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static Expression map(Expression input, Schema.FieldType mapValueType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.value((Expression)value, mapValueType));
            return Expressions.new_(WrappedMap.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Map.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static Expression row(Expression input, Schema schema) {
            ParameterExpression row = Expressions.parameter(Row.class);
            ParameterExpression index = Expressions.parameter(Integer.TYPE);
            BlockBuilder body = new BlockBuilder(false);
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                BlockBuilder list = new BlockBuilder(false, body);
                Expression returnValue = InputGetterImpl.value(list, i, null, (Expression)row, schema);
                list.append(returnValue);
                body.append("if i=" + i, Expressions.block((Statement[])new Statement[]{Expressions.ifThen((Expression)Expressions.equal((Expression)index, (Expression)Expressions.constant((Object)i, Integer.TYPE)), (Node)list.toBlock())}));
            }
            body.add((Statement)Expressions.throw_((Expression)Expressions.new_(IndexOutOfBoundsException.class)));
            return Expressions.new_(WrappedRow.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Row.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"field", (Iterable)ImmutableList.of((Object)row, (Object)index), (BlockStatement)body.toBlock())));
        }
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final String processElementBlock;
        private final Schema outputSchema;
        @Nullable
        private transient ScriptEvaluator se = null;

        public CalcFn(String processElementBlock, Schema outputSchema) {
            this.processElementBlock = processElementBlock;
            this.outputSchema = outputSchema;
        }

        ScriptEvaluator compile() {
            ScriptEvaluator se = new ScriptEvaluator();
            se.setParameters(new String[]{outputSchemaParam.name, processContextParam.name, DataContext.ROOT.name}, new Class[]{(Class)outputSchemaParam.getType(), (Class)processContextParam.getType(), (Class)DataContext.ROOT.getType()});
            try {
                se.cook(this.processElementBlock);
            }
            catch (CompileException e) {
                throw new UnsupportedOperationException("Could not compile CalcFn: " + this.processElementBlock, e);
            }
            return se;
        }

        @DoFn.Setup
        public void setup() {
            this.se = this.compile();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            assert (this.se != null);
            try {
                this.se.evaluate(new Object[]{this.outputSchema, c, CONTEXT_INSTANCE});
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("CalcFn failed to evaluate: " + this.processElementBlock, e.getCause());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object[])new Object[]{BeamCalcRel.class.getSimpleName(), pinput});
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema(BeamCalcRel.this.getRowType());
            SqlConformanceEnum conformance = SqlConformanceEnum.MYSQL_5;
            JavaTypeFactory typeFactory = BeamJavaTypeFactory.INSTANCE;
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)BeamCalcRel.this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false);
            UnaryExpression input = Expressions.convert_((Expression)Expressions.call((Expression)processContextParam, (String)"element", (Expression[])new Expression[0]), Row.class);
            RexBuilder rexBuilder = BeamCalcRel.this.getCluster().getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(BeamCalcRel.this.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, RexUtil.EXECUTOR);
            RexProgram program = BeamCalcRel.this.getProgram().normalize(rexBuilder, simplify);
            Expression condition = RexToLixTranslator.translateCondition((RexProgram)program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder, (RexToLixTranslator.InputGetter)new InputGetterImpl((Expression)input, upstream.getSchema()), null, (SqlConformance)conformance);
            List expressions = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)typeFactory, (SqlConformance)conformance, (BlockBuilder)builder, (PhysType)physType, (Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)new InputGetterImpl((Expression)input, upstream.getSchema()), null);
            MethodCallExpression output = Expressions.call(Row.class, (String)"withSchema", (Expression[])new Expression[]{outputSchemaParam});
            Method addValue = Types.lookupMethod(Row.Builder.class, (String)"addValue", (Class[])new Class[]{Object.class});
            for (int index = 0; index < expressions.size(); ++index) {
                Expression value = (Expression)expressions.get(index);
                Schema.FieldType toType = outputSchema.getField(index).getType();
                output = Expressions.call((Expression)output, (Method)addValue, (Expression[])new Expression[]{BeamCalcRel.castOutput(value, toType)});
            }
            output = Expressions.call((Expression)output, (String)"build", (Expression[])new Expression[0]);
            builder.add((Statement)Expressions.ifThen((Expression)condition, (Node)Expressions.makeGoto((GotoExpressionKind)GotoExpressionKind.Sequence, null, (Expression)Expressions.call((Expression)processContextParam, (Method)Types.lookupMethod(DoFn.ProcessContext.class, (String)"output", (Class[])new Class[]{Object.class}), (Expression[])new Expression[]{output}))));
            CalcFn calcFn = new CalcFn(builder.toBlock().toString(), outputSchema);
            calcFn.compile();
            PCollection projectStream = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
            return projectStream;
        }
    }
}

