/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.TimestampString;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class DateString
implements Comparable<DateString> {
    private static final Pattern PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]");
    final String v;

    public DateString(String v) {
        this.v = v;
        Preconditions.checkArgument(PATTERN.matcher(v).matches(), v);
    }

    public DateString(int year, int month, int day) {
        this(TimestampString.ymd(new StringBuilder(), year, month, day).toString());
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DateString && ((DateString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(DateString o) {
        return this.v.compareTo(o.v);
    }

    public static DateString fromCalendarFields(Calendar calendar) {
        return new DateString(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public int getDaysSinceEpoch() {
        int year = Integer.valueOf(this.v.substring(0, 4));
        int month = Integer.valueOf(this.v.substring(5, 7));
        int day = Integer.valueOf(this.v.substring(8, 10));
        return DateTimeUtils.ymdToUnixDate(year, month, day);
    }

    public static DateString fromDaysSinceEpoch(int days) {
        return new DateString(DateTimeUtils.unixDateToString(days));
    }

    public long getMillisSinceEpoch() {
        return (long)this.getDaysSinceEpoch() * 86400000L;
    }

    public Calendar toCalendar() {
        return Util.calendar(this.getMillisSinceEpoch());
    }
}

