/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.util.SqlVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ImmutableNullableList;

public class SqlMatchRecognize
extends SqlCall {
    public static final int OPERAND_TABLE_REF = 0;
    public static final int OPERAND_PATTERN = 1;
    public static final int OPERAND_STRICT_START = 2;
    public static final int OPERAND_STRICT_END = 3;
    public static final int OPERAND_PATTERN_DEFINES = 4;
    public static final int OPERAND_MEASURES = 5;
    public static final int OPERAND_AFTER = 6;
    public static final int OPERAND_SUBSET = 7;
    public static final int OPERAND_ROWS_PER_MATCH = 8;
    public static final int OPERAND_PARTITION_BY = 9;
    public static final int OPERAND_ORDER_BY = 10;
    public static final SqlPrefixOperator SKIP_TO_FIRST = new SqlPrefixOperator("SKIP TO FIRST", SqlKind.SKIP_TO_FIRST, 20, null, null, null);
    public static final SqlPrefixOperator SKIP_TO_LAST = new SqlPrefixOperator("SKIP TO LAST", SqlKind.SKIP_TO_LAST, 20, null, null, null);
    private SqlNode tableRef;
    private SqlNode pattern;
    private SqlLiteral strictStart;
    private SqlLiteral strictEnd;
    private SqlNodeList patternDefList;
    private SqlNodeList measureList;
    private SqlNode after;
    private SqlNodeList subsetList;
    private SqlLiteral rowsPerMatch;
    private SqlNodeList partitionList;
    private SqlNodeList orderList;

    public SqlMatchRecognize(SqlParserPos pos, SqlNode tableRef, SqlNode pattern, SqlLiteral strictStart, SqlLiteral strictEnd, SqlNodeList patternDefList, SqlNodeList measureList, SqlNode after, SqlNodeList subsetList, SqlLiteral rowsPerMatch, SqlNodeList partitionList, SqlNodeList orderList) {
        super(pos);
        this.tableRef = Preconditions.checkNotNull(tableRef);
        this.pattern = Preconditions.checkNotNull(pattern);
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefList = Preconditions.checkNotNull(patternDefList);
        Preconditions.checkArgument(patternDefList.size() > 0);
        this.measureList = Preconditions.checkNotNull(measureList);
        this.after = after;
        this.subsetList = subsetList;
        Preconditions.checkArgument(rowsPerMatch == null || rowsPerMatch.value instanceof RowsPerMatchOption);
        this.rowsPerMatch = rowsPerMatch;
        this.partitionList = Preconditions.checkNotNull(partitionList);
        this.orderList = Preconditions.checkNotNull(orderList);
    }

    @Override
    public SqlOperator getOperator() {
        return SqlMatchRecognizeOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.MATCH_RECOGNIZE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableRef, this.pattern, this.strictStart, this.strictEnd, this.patternDefList, this.measureList, this.after, this.subsetList, new SqlNode[]{this.partitionList, this.orderList});
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.getOperator().unparse(writer, this, 0, 0);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateMatchRecognize(this);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.tableRef = Preconditions.checkNotNull(operand);
                break;
            }
            case 1: {
                this.pattern = operand;
                break;
            }
            case 2: {
                this.strictStart = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.strictEnd = (SqlLiteral)operand;
                break;
            }
            case 4: {
                this.patternDefList = Preconditions.checkNotNull((SqlNodeList)operand);
                Preconditions.checkArgument(this.patternDefList.size() > 0);
                break;
            }
            case 5: {
                this.measureList = Preconditions.checkNotNull((SqlNodeList)operand);
                break;
            }
            case 6: {
                this.after = operand;
                break;
            }
            case 7: {
                this.subsetList = (SqlNodeList)operand;
                break;
            }
            case 8: {
                this.rowsPerMatch = (SqlLiteral)operand;
                Preconditions.checkArgument(this.rowsPerMatch == null || this.rowsPerMatch.value instanceof RowsPerMatchOption);
                break;
            }
            case 9: {
                this.partitionList = (SqlNodeList)operand;
                break;
            }
            case 10: {
                this.orderList = (SqlNodeList)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Nonnull
    public SqlNode getTableRef() {
        return this.tableRef;
    }

    public SqlNode getPattern() {
        return this.pattern;
    }

    public SqlLiteral getStrictStart() {
        return this.strictStart;
    }

    public SqlLiteral getStrictEnd() {
        return this.strictEnd;
    }

    @Nonnull
    public SqlNodeList getPatternDefList() {
        return this.patternDefList;
    }

    @Nonnull
    public SqlNodeList getMeasureList() {
        return this.measureList;
    }

    public SqlNode getAfter() {
        return this.after;
    }

    public SqlNodeList getSubsetList() {
        return this.subsetList;
    }

    public SqlLiteral getRowsPerMatch() {
        return this.rowsPerMatch;
    }

    public SqlNodeList getPartitionList() {
        return this.partitionList;
    }

    public SqlNodeList getOrderList() {
        return this.orderList;
    }

    public static class SqlMatchRecognizeOperator
    extends SqlOperator {
        public static final SqlMatchRecognizeOperator INSTANCE = new SqlMatchRecognizeOperator();

        private SqlMatchRecognizeOperator() {
            super("MATCH_RECOGNIZE", SqlKind.MATCH_RECOGNIZE, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 11);
            return new SqlMatchRecognize(pos, operands[0], operands[1], (SqlLiteral)operands[2], (SqlLiteral)operands[3], (SqlNodeList)operands[4], (SqlNodeList)operands[5], operands[6], (SqlNodeList)operands[7], (SqlLiteral)operands[8], (SqlNodeList)operands[9], (SqlNodeList)operands[10]);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    SqlNode operand = operands.get(i);
                    if (operand == null) continue;
                    argHandler.visitChild(visitor, call, i, operand);
                }
            } else {
                super.acceptCall(visitor, call, onlyExpressions, argHandler);
            }
        }

        @Override
        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            validator.validateMatchRecognize(call);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlMatchRecognize pattern = (SqlMatchRecognize)call;
            pattern.tableRef.unparse(writer, 0, 0);
            SqlWriter.Frame mrFrame = writer.startFunCall("MATCH_RECOGNIZE");
            if (pattern.partitionList != null && pattern.partitionList.size() > 0) {
                writer.newlineAndIndent();
                writer.sep("PARTITION BY");
                SqlWriter.Frame partitionFrame = writer.startList("", "");
                pattern.partitionList.unparse(writer, 0, 0);
                writer.endList(partitionFrame);
            }
            if (pattern.orderList != null && pattern.orderList.size() > 0) {
                writer.newlineAndIndent();
                writer.sep("ORDER BY");
                SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY_LIST);
                this.unparseListClause(writer, pattern.orderList);
                writer.endList(orderFrame);
            }
            if (pattern.measureList != null && pattern.measureList.size() > 0) {
                writer.newlineAndIndent();
                writer.sep("MEASURES");
                SqlWriter.Frame measureFrame = writer.startList("", "");
                pattern.measureList.unparse(writer, 0, 0);
                writer.endList(measureFrame);
            }
            if (pattern.rowsPerMatch != null) {
                writer.newlineAndIndent();
                pattern.rowsPerMatch.unparse(writer, 0, 0);
            }
            if (pattern.after != null) {
                writer.newlineAndIndent();
                writer.sep("AFTER MATCH");
                pattern.after.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.sep("PATTERN");
            SqlWriter.Frame patternFrame = writer.startList("(", ")");
            if (pattern.strictStart.booleanValue()) {
                writer.sep("^");
            }
            pattern.pattern.unparse(writer, 0, 0);
            if (pattern.strictEnd.booleanValue()) {
                writer.sep("$");
            }
            writer.endList(patternFrame);
            if (pattern.subsetList != null && pattern.subsetList.size() > 0) {
                writer.newlineAndIndent();
                writer.sep("SUBSET");
                SqlWriter.Frame subsetFrame = writer.startList("", "");
                pattern.subsetList.unparse(writer, 0, 0);
                writer.endList(subsetFrame);
            }
            writer.newlineAndIndent();
            writer.sep("DEFINE");
            SqlWriter.Frame patternDefFrame = writer.startList("", "");
            SqlNodeList newDefineList = new SqlNodeList(SqlParserPos.ZERO);
            for (SqlNode node : pattern.getPatternDefList()) {
                SqlCall call2 = (SqlCall)node;
                newDefineList.add(call2.getOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{call2.operand(1), call2.operand(0)}));
            }
            newDefineList.unparse(writer, 0, 0);
            writer.endList(patternDefFrame);
            writer.endList(mrFrame);
        }
    }

    public static enum AfterOption {
        SKIP_TO_NEXT_ROW("SKIP TO NEXT ROW"),
        SKIP_PAST_LAST_ROW("SKIP PAST LAST ROW");

        private final String sql;

        private AfterOption(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }

        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }

    public static enum RowsPerMatchOption {
        ONE_ROW("ONE ROW PER MATCH"),
        ALL_ROWS("ALL ROWS PER MATCH");

        private final String sql;

        private RowsPerMatchOption(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }

        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

