/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Predicate;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Project;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.PredicateImpl;

public class ProjectRemoveRule
extends RelOptRule {
    private static final Predicate<Project> PREDICATE = new PredicateImpl<Project>(){

        @Override
        public boolean test(Project input) {
            return ProjectRemoveRule.isTrivial(input);
        }
    };
    public static final ProjectRemoveRule INSTANCE = new ProjectRemoveRule();

    private ProjectRemoveRule() {
        super(ProjectRemoveRule.operand(Project.class, null, PREDICATE, ProjectRemoveRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        assert (ProjectRemoveRule.isTrivial(project));
        RelNode stripped = project.getInput();
        if (stripped instanceof Project) {
            Project childProject = (Project)stripped;
            stripped = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), project.getRowType());
        }
        RelNode child = call.getPlanner().register(stripped, project);
        call.transformTo(child);
    }

    public static RelNode strip(Project project) {
        return ProjectRemoveRule.isTrivial(project) ? project.getInput() : project;
    }

    public static boolean isTrivial(Project project) {
        return RexUtil.isIdentity(project.getProjects(), project.getInput().getRowType());
    }

    @Deprecated
    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType childRowType) {
        return RexUtil.isIdentity(exps, childRowType);
    }
}

