/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core;

import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.Convention;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTrait;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.EquiJoin;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinInfo;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ImmutableIntList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class SemiJoin
extends EquiJoin {
    public SemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        super(cluster, traitSet, left, right, condition, leftKeys, rightKeys, ImmutableSet.of(), JoinRelType.INNER);
    }

    public static SemiJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        RelOptCluster cluster = left.getCluster();
        return new SemiJoin(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), left, right, condition, leftKeys, rightKeys);
    }

    @Override
    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        return new SemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeTinyCost();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first(RelMdUtil.getSemiJoinRowCount(mq, this.left, this.right, this.joinType, this.condition), 1.0);
    }

    @Override
    public RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType(this.left.getRowType(), null, JoinRelType.INNER, this.getCluster().getTypeFactory(), null, ImmutableList.of());
    }
}

